/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonPointer;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.SchemaLoaderKt;
import com.github.erosb.jsonsKema.SourceLocation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"loadFromYaml", "Lcom/github/erosb/jsonsKema/JsonValue;", "node", "Lorg/yaml/snakeyaml/nodes/Node;", "documentSource", "Ljava/net/URI;", "ptr", "Lcom/github/erosb/jsonsKema/JsonPointer;", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nYamlSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlSupport.kt\ncom/github/erosb/jsonsKema/YamlSupportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1563#2:56\n1634#2,3:57\n1573#2:60\n1604#2,4:61\n*S KotlinDebug\n*F\n+ 1 YamlSupport.kt\ncom/github/erosb/jsonsKema/YamlSupportKt\n*L\n37#1:56\n37#1:57,3\n46#1:60\n46#1:61,4\n*E\n"})
public final class YamlSupportKt {
    @NotNull
    public static final JsonValue loadFromYaml(@NotNull Node node, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        return YamlSupportKt.loadFromYaml(node, new JsonPointer(new String[0]), documentSource);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonValue loadFromYaml(@NotNull Node node, @NotNull JsonPointer ptr, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(ptr, "ptr");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        SourceLocation location = new SourceLocation(node.getStartMark().getLine() + 1, node.getStartMark().getColumn() + 1, ptr, documentSource);
        Object object = node;
        if (object instanceof ScalarNode) {
            if (Intrinsics.areEqual(((ScalarNode)node).getTag(), Tag.NULL)) {
                return new JsonNull(location);
            }
            if (Intrinsics.areEqual(((ScalarNode)node).getTag(), Tag.STR)) {
                String string = ((ScalarNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                return new JsonString(string, location);
            }
            if (Intrinsics.areEqual(((ScalarNode)node).getTag(), Tag.BOOL)) {
                String[] stringArray = new String[]{"yes", "y", "on", "true"};
                List<String> list = CollectionsKt.listOf(stringArray);
                String string = ((ScalarNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                boolean value = list.contains(string2);
                return new JsonBoolean(value, location);
            }
            if (Intrinsics.areEqual(((ScalarNode)node).getTag(), Tag.INT)) {
                String string = ((ScalarNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                return new JsonNumber(Integer.parseInt(string), location);
            }
            if (Intrinsics.areEqual(((ScalarNode)node).getTag(), Tag.FLOAT)) {
                String string = ((ScalarNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                return new JsonNumber(Double.parseDouble(string), location);
            }
        } else {
            if (object instanceof MappingNode) {
                void $this$mapTo$iv$iv;
                List<NodeTuple> list = ((MappingNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(list, "getValue(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NodeTuple nodeTuple = (NodeTuple)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Node node2 = it.getKeyNode();
                    Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.yaml.snakeyaml.nodes.ScalarNode");
                    String string = ((ScalarNode)node2).getValue();
                    Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                    JsonPointer nextPtr = ptr.plus(string);
                    Node node3 = it.getKeyNode();
                    Intrinsics.checkNotNullExpressionValue(node3, "getKeyNode(...)");
                    IJsonString iJsonString = YamlSupportKt.loadFromYaml(node3, ptr, documentSource).requireString();
                    Intrinsics.checkNotNull(iJsonString, "null cannot be cast to non-null type com.github.erosb.jsonsKema.JsonString");
                    JsonString jsonPropName = (JsonString)iJsonString;
                    Node node4 = it.getValueNode();
                    Intrinsics.checkNotNullExpressionValue(node4, "getValueNode(...)");
                    JsonValue jsonPropValue = YamlSupportKt.loadFromYaml(node4, nextPtr, documentSource);
                    collection.add(TuplesKt.to(jsonPropName, jsonPropValue));
                }
                Map props = MapsKt.toMap((List)destination$iv$iv);
                return new JsonObject(props, location);
            }
            if (object instanceof SequenceNode) {
                void $this$mapIndexedTo$iv$iv;
                List<Node> list = ((SequenceNode)node).getValue();
                Intrinsics.checkNotNullExpressionValue(list, "getValue(...)");
                Iterable $this$mapIndexed$iv = list;
                boolean $i$f$mapIndexed = false;
                Iterable $this$mapTo$iv$iv = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void childNode;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Node nextPtr = (Node)item$iv$iv;
                    int jsonPropName = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    JsonPointer childPtr = ptr.plus(String.valueOf((int)index));
                    Intrinsics.checkNotNull(childNode);
                    collection.add(YamlSupportKt.loadFromYaml((Node)childNode, childPtr, documentSource));
                }
                List items = (List)destination$iv$iv;
                return new JsonArray(items, location);
            }
        }
        object = "unhandled type " + node.getClass() + " / " + node.getTag();
        throw new NotImplementedError("An operation is not implemented: " + (String)object);
    }

    public static /* synthetic */ JsonValue loadFromYaml$default(Node node, JsonPointer jsonPointer, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            jsonPointer = new JsonPointer(new String[0]);
        }
        if ((n & 4) != 0) {
            uRI = SchemaLoaderKt.getDEFAULT_BASE_URI();
        }
        return YamlSupportKt.loadFromYaml(node, jsonPointer, uRI);
    }
}

