/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.EmailValidationResult;
import com.sanctionco.jmail.FailureReason;
import com.sanctionco.jmail.InvalidEmailException;
import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.TopLevelDomain;
import com.sanctionco.jmail.ValidationRules;
import com.sanctionco.jmail.disposable.DisposableDomainSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EmailValidator {
    private static final Predicate<Email> DISALLOW_IP_DOMAIN_PREDICATE = ValidationRules::disallowIpDomain;
    private static final Predicate<Email> REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE = ValidationRules::requireTopLevelDomain;
    private static final Predicate<Email> DISALLOW_SINGLE_CHAR_TOP_LEVEL_DOMAINS_PREDICATE = ValidationRules::disallowSingleCharacterTopLevelDomains;
    private static final Predicate<Email> DISALLOW_EXPLICIT_SOURCE_ROUTING_PREDICATE = ValidationRules::disallowExplicitSourceRouting;
    private static final Predicate<Email> DISALLOW_QUOTED_IDENTIFIERS_PREDICATE = ValidationRules::disallowQuotedIdentifiers;
    private static final Predicate<Email> DISALLOW_RESERVED_DOMAINS_PREDICATE = ValidationRules::disallowReservedDomains;
    private static final Predicate<Email> DISALLOW_OBSOLETE_WHITESPACE_PREDICATE = ValidationRules::disallowObsoleteWhitespace;
    private static final Predicate<Email> REQUIRE_VALID_MX_RECORD_PREDICATE = ValidationRules::requireValidMXRecord;
    private static final Predicate<Email> REQUIRE_ASCII_PREDICATE = ValidationRules::requireAscii;
    private final Map<Predicate<Email>, FailureReason> validationPredicates;
    private final boolean allowNonstandardDots;

    EmailValidator(Map<Predicate<Email>, FailureReason> validationPredicates, boolean allowNonstandardDots) {
        this.validationPredicates = Collections.unmodifiableMap(validationPredicates);
        this.allowNonstandardDots = allowNonstandardDots;
    }

    EmailValidator() {
        this(new HashMap<Predicate<Email>, FailureReason>(), false);
    }

    public EmailValidator withRules(Map<Predicate<Email>, FailureReason> rules) {
        LinkedHashMap<Predicate<Email>, FailureReason> ruleMap = new LinkedHashMap<Predicate<Email>, FailureReason>(this.validationPredicates);
        ruleMap.putAll(rules);
        return new EmailValidator(ruleMap, this.allowNonstandardDots);
    }

    public EmailValidator withRules(Collection<Predicate<Email>> rules) {
        return this.withRules(rules.stream().collect(Collectors.toMap(p -> p, p -> FailureReason.FAILED_CUSTOM_VALIDATION)));
    }

    public EmailValidator withRule(Predicate<Email> rule) {
        return this.withRules(Collections.singletonMap(rule, FailureReason.FAILED_CUSTOM_VALIDATION));
    }

    public EmailValidator withRule(Predicate<Email> rule, FailureReason failureReason) {
        return this.withRules(Collections.singletonMap(rule, failureReason));
    }

    public EmailValidator withRule(Predicate<Email> rule, String failureReason) {
        return this.withRules(Collections.singletonMap(rule, new FailureReason(failureReason)));
    }

    public EmailValidator allowNonstandardDots() {
        return new EmailValidator(this.validationPredicates, true);
    }

    public EmailValidator disallowIpDomain() {
        return this.withRule(DISALLOW_IP_DOMAIN_PREDICATE, FailureReason.CONTAINS_IP_DOMAIN);
    }

    public EmailValidator requireTopLevelDomain() {
        return this.withRule(REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE, FailureReason.MISSING_TOP_LEVEL_DOMAIN);
    }

    public EmailValidator disallowSingleCharacterTopLevelDomains() {
        return this.withRule(DISALLOW_SINGLE_CHAR_TOP_LEVEL_DOMAINS_PREDICATE, FailureReason.SINGLE_CHARACTER_TOP_LEVEL_DOMAIN);
    }

    public EmailValidator disallowExplicitSourceRouting() {
        return this.withRule(DISALLOW_EXPLICIT_SOURCE_ROUTING_PREDICATE, FailureReason.CONTAINS_EXPLICIT_SOURCE_ROUTING);
    }

    public EmailValidator disallowQuotedIdentifiers() {
        return this.withRule(DISALLOW_QUOTED_IDENTIFIERS_PREDICATE, FailureReason.CONTAINS_QUOTED_IDENTIFIER);
    }

    public EmailValidator disallowReservedDomains() {
        return this.withRule(DISALLOW_RESERVED_DOMAINS_PREDICATE, FailureReason.CONTAINS_RESERVED_DOMAIN);
    }

    public EmailValidator requireOnlyTopLevelDomains(TopLevelDomain ... allowed) {
        return this.withRule((Email email) -> ValidationRules.requireOnlyTopLevelDomains(email, Arrays.stream(allowed).collect(Collectors.toSet())), FailureReason.INVALID_TOP_LEVEL_DOMAIN);
    }

    public EmailValidator disallowObsoleteWhitespace() {
        return this.withRule(DISALLOW_OBSOLETE_WHITESPACE_PREDICATE, FailureReason.CONTAINS_OBSOLETE_WHITESPACE);
    }

    public EmailValidator requireValidMXRecord() {
        return this.withRule(REQUIRE_VALID_MX_RECORD_PREDICATE, FailureReason.INVALID_MX_RECORD);
    }

    public EmailValidator requireValidMXRecord(int initialTimeout, int numRetries) {
        return this.withRule((Email email) -> ValidationRules.requireValidMXRecord(email, initialTimeout, numRetries), FailureReason.INVALID_MX_RECORD);
    }

    public EmailValidator disallowDisposableDomains(DisposableDomainSource disposableDomainSource) {
        return this.withRule((Email email) -> ValidationRules.disallowDisposableDomains(email, disposableDomainSource), FailureReason.CONTAINS_DISPOSABLE_DOMAIN);
    }

    public EmailValidator requireAscii() {
        return this.withRule(REQUIRE_ASCII_PREDICATE, FailureReason.NON_ASCII_ADDRESS);
    }

    public boolean isValid(String email) {
        return JMail.validate(email, this.allowNonstandardDots).getEmail().filter(e -> !this.testPredicates((Email)e).isPresent()).isPresent();
    }

    public boolean isInvalid(String email) {
        return !this.isValid(email);
    }

    public void enforceValid(String email) throws InvalidEmailException {
        if (!this.isValid(email)) {
            throw new InvalidEmailException();
        }
    }

    public EmailValidationResult validate(String email) {
        EmailValidationResult result = JMail.validate(email, this.allowNonstandardDots);
        if (!result.getEmail().isPresent()) {
            return result;
        }
        return this.testPredicates(result.getEmail().get()).map(EmailValidationResult::failure).orElse(result);
    }

    public Optional<Email> tryParse(String email) {
        return JMail.validate(email, this.allowNonstandardDots).getEmail().filter(e -> !this.testPredicates((Email)e).isPresent());
    }

    private Optional<FailureReason> testPredicates(Email email) {
        return this.validationPredicates.entrySet().stream().filter(entry -> !((Predicate)entry.getKey()).test(email)).findFirst().map(Map.Entry::getValue);
    }

    public String toString() {
        return new StringJoiner(", ", EmailValidator.class.getSimpleName() + "[", "]").add("validationRuleCount=" + this.validationPredicates.size()).toString();
    }
}

