/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.disposable;

import com.sanctionco.jmail.disposable.DisposableDomainSource;
import com.sanctionco.jmail.disposable.JavaCollectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class InputStreamSource
implements DisposableDomainSource {
    private final Set<String> disposableDomains;

    InputStreamSource(InputStream inputStream) throws IOException {
        this.disposableDomains = InputStreamSource.readAllLines(inputStream);
    }

    @Override
    public boolean isDisposableDomain(String domain) {
        return this.disposableDomains.contains(domain.toLowerCase());
    }

    private static Set<String> readAllLines(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            return bufferedReader.lines().map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(JavaCollectors.toUnmodifiableSet());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

