/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.disposable;

import com.sanctionco.jmail.disposable.DisposableDomainSource;
import com.sanctionco.jmail.disposable.HttpClient;

public class IsTempMailAPISource
implements DisposableDomainSource {
    private static final String BASE_URL = "https://istempmail.com/api/check/";
    private final HttpClient httpClient;
    private final String apiKey;

    IsTempMailAPISource(HttpClient httpClient, String apiKey) {
        this.httpClient = httpClient;
        this.apiKey = apiKey;
    }

    @Override
    public boolean isDisposableDomain(String domain) {
        String url = BASE_URL + this.apiKey + "/" + domain;
        String httpResponse = this.httpClient.get(url);
        return this.parseBlockedValue(httpResponse);
    }

    private boolean parseBlockedValue(String s) {
        int keyIndex;
        int colonIndex;
        boolean resp = false;
        if (s.contains("blocked") && (colonIndex = s.indexOf(":", keyIndex = s.indexOf("blocked"))) != -1) {
            int valueEnd;
            int valueStart;
            for (valueStart = colonIndex + 1; valueStart < s.length() && Character.isWhitespace(s.charAt(valueStart)); ++valueStart) {
            }
            for (valueEnd = valueStart; valueEnd < s.length() && s.charAt(valueEnd) != ',' && s.charAt(valueEnd) != '}'; ++valueEnd) {
            }
            String rawValue = s.substring(valueStart, valueEnd).trim();
            resp = "true".equals(rawValue);
        }
        return resp;
    }
}

