/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.extension;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFormatDetector;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESService;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.AbstractDocumentExtender;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import java.util.Objects;

public class ASiCWithCAdESDocumentExtender
extends AbstractDocumentExtender<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> {
    ASiCWithCAdESDocumentExtender() {
    }

    public ASiCWithCAdESDocumentExtender(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be extended cannot be null!");
        this.document = document;
    }

    @Override
    protected DocumentSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> createSignatureService() {
        Objects.requireNonNull(this.certificateVerifier, "Please provide CertificateVerifier or corresponding ASiCWithCAdESService!");
        ASiCWithCAdESService service = new ASiCWithCAdESService(this.certificateVerifier);
        service.setTspSource(this.tspSource);
        return service;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new ASiCWithCAdESFormatDetector().isSupportedASiC(dssDocument);
    }

    @Override
    protected ASiCWithCAdESSignatureParameters emptySignatureParameters() {
        return new ASiCWithCAdESSignatureParameters();
    }

    @Override
    protected boolean isSupportedParameters(SerializableSignatureParameters parameters) {
        return parameters instanceof ASiCWithCAdESSignatureParameters;
    }

    @Override
    protected boolean isSupportedService(DocumentSignatureService<?, ?> service) {
        return service instanceof ASiCWithCAdESService;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }

    @Override
    public boolean isASiC() {
        return false;
    }
}

