/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.merge;

import eu.europa.esig.dss.asic.cades.merge.AbstractASiCWithCAdESContainerMerger;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.definition.ASiCManifestAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCManifestPath;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESContainerMerger
extends AbstractASiCWithCAdESContainerMerger {
    ASiCEWithCAdESContainerMerger() {
    }

    public ASiCEWithCAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCEWithCAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && (!ASiCUtils.isASiCSContainer(container) || this.doesNotContainSignatures(container) && this.doesNotContainTimestamps(container) && this.doesNotContainEvidenceRecords(container));
    }

    private boolean doesNotContainSignatures(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainSignatures(entryNames);
    }

    private boolean doesNotContainTimestamps(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainTimestamps(entryNames);
    }

    private boolean doesNotContainEvidenceRecords(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainEvidenceRecords(entryNames);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && (!ASiCUtils.isASiCSContainer(asicContent) || this.doesNotContainSignatures(asicContent) && this.doesNotContainTimestamps(asicContent) && this.doesNotContainEvidenceRecords(asicContent));
    }

    private boolean doesNotContainSignatures(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getSignatureDocuments());
    }

    private boolean doesNotContainTimestamps(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getTimestampDocuments());
    }

    private boolean doesNotContainEvidenceRecords(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getEvidenceRecordDocuments());
    }

    @Override
    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_E;
    }

    @Override
    protected void ensureContainerContentAllowMerge() {
    }

    @Override
    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments()) || Utils.isCollectionNotEmpty(asicContent.getEvidenceRecordDocuments())).count() <= 1L) {
            return;
        }
        this.ensureSignatureDocumentsValid();
        this.ensureEvidenceRecordDocumentsValid();
        this.ensureManifestDocumentsValid();
    }

    private void ensureSignatureDocumentsValid() {
        ArrayList<String> mergedSignatureNames = new ArrayList<String>();
        ArrayList<ASiCContent> asicContentsToProcess = new ArrayList<ASiCContent>(Arrays.asList(this.asicContents));
        Iterator iterator2 = asicContentsToProcess.iterator();
        while (iterator2.hasNext()) {
            ASiCContent asicContent = (ASiCContent)iterator2.next();
            iterator2.remove();
            ArrayList<DSSDocument> signatureDocumentList = new ArrayList<DSSDocument>(asicContent.getSignatureDocuments());
            for (DSSDocument signatureDocument : signatureDocumentList) {
                List<DSSDocument> signaturesToMerge;
                if (mergedSignatureNames.contains(signatureDocument.getName()) || !Utils.isCollectionNotEmpty(signaturesToMerge = this.getSignatureDocumentsToBeMerged(asicContent, signatureDocument, asicContentsToProcess))) continue;
                signaturesToMerge.add(signatureDocument);
                mergedSignatureNames.add(signatureDocument.getName());
                DSSDocument signaturesCms = this.mergeCmsSignatures(signaturesToMerge);
                this.updateMergedSignatureInContainers(signaturesCms);
            }
        }
    }

    private List<DSSDocument> getSignatureDocumentsToBeMerged(ASiCContent currentASiCContent, DSSDocument currentSignatureDocument, List<ASiCContent> asicContentList) {
        if (currentSignatureDocument.getName() == null) {
            throw new IllegalInputException("Name shall be provided for a document!");
        }
        DSSDocument manifest = ASiCManifestParser.getLinkedManifest(currentASiCContent.getAllManifestDocuments(), currentSignatureDocument.getName());
        if (manifest == null) {
            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with filename '%s' does not have a corresponding manifest file!", currentSignatureDocument.getName()));
        }
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ASiCContent asicContentToCompare : asicContentList) {
            DSSDocument signatureToCompare = DSSUtils.getDocumentWithName(asicContentToCompare.getSignatureDocuments(), currentSignatureDocument.getName());
            if (signatureToCompare == null) continue;
            DSSDocument manifestToCompare = ASiCManifestParser.getLinkedManifest(asicContentToCompare.getAllManifestDocuments(), signatureToCompare.getName());
            if (manifestToCompare == null) {
                throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with filename '%s' does not have a corresponding manifest file!", signatureToCompare.getName()));
            }
            if (ASiCUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentSignatureDocument.getName()) || ASiCUtils.isCoveredByManifest(asicContentToCompare.getAllManifestDocuments(), signatureToCompare.getName())) {
                throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with name '%s' in a container is covered by a manifest!", currentSignatureDocument.getName()));
            }
            if (manifest.getName().equals(manifestToCompare.getName()) && Arrays.equals(manifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM), manifestToCompare.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) {
                result.add(signatureToCompare);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. Signatures with filename '%s' sign different manifests!", currentSignatureDocument.getName()));
        }
        return result;
    }

    private void updateMergedSignatureInContainers(DSSDocument mergedCmsSignature) {
        for (ASiCContent asicContent : this.asicContents) {
            if (!DSSUtils.getDocumentNames(asicContent.getSignatureDocuments()).contains(mergedCmsSignature.getName())) continue;
            ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), mergedCmsSignature);
        }
    }

    private void ensureManifestDocumentsValid() {
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getManifestDocuments().addAll(asicContent.getManifestDocuments());
            mergedASiCContent.getArchiveManifestDocuments().addAll(asicContent.getArchiveManifestDocuments());
            mergedASiCContent.getEvidenceRecordManifestDocuments().addAll(asicContent.getEvidenceRecordManifestDocuments());
        }
        ArrayList<ASiCContent> asicContentsToProcess = new ArrayList<ASiCContent>(Arrays.asList(this.asicContents));
        Iterator iterator2 = asicContentsToProcess.iterator();
        while (iterator2.hasNext()) {
            ASiCContent asicContent = (ASiCContent)iterator2.next();
            iterator2.remove();
            this.ensureSimpleManifestDocumentsValid(mergedASiCContent, asicContentsToProcess, asicContent);
            this.ensureArchiveManifestDocumentsValid(mergedASiCContent, asicContentsToProcess, asicContent);
            this.ensureEvidenceRecordManifestDocumentsValid(mergedASiCContent, asicContentsToProcess, asicContent);
        }
    }

    private void ensureSimpleManifestDocumentsValid(ASiCContent mergedASiCContent, List<ASiCContent> asicContentsToProcess, ASiCContent asicContent) {
        for (DSSDocument manifest : asicContent.getManifestDocuments()) {
            for (ASiCContent currentASiCContent : asicContentsToProcess) {
                for (DSSDocument currentManifest : currentASiCContent.getManifestDocuments()) {
                    if (manifest.getName() == null || !manifest.getName().equals(currentManifest.getName()) || Arrays.equals(manifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM), currentManifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
                    if (ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), manifest.getName()) || ASiCUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentManifest.getName())) {
                        throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A manifest with name '%s' in a container is covered by another manifest!", currentManifest.getName()));
                    }
                    String newManifestName = this.asicFilenameFactory.getManifestFilename(mergedASiCContent);
                    currentManifest.setName(newManifestName);
                }
            }
        }
    }

    private void ensureArchiveManifestDocumentsValid(ASiCContent mergedASiCContent, List<ASiCContent> asicContentsToProcess, ASiCContent asicContent) {
        for (DSSDocument manifest : asicContent.getArchiveManifestDocuments()) {
            for (ASiCContent currentASiCContent : asicContentsToProcess) {
                for (DSSDocument currentManifest : currentASiCContent.getArchiveManifestDocuments()) {
                    if (manifest.getName() == null || !manifest.getName().equals(currentManifest.getName()) || Arrays.equals(manifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM), currentManifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
                    if (ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), manifest.getName()) || ASiCUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentManifest.getName())) {
                        throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A manifest with name '%s' in a container is covered by another manifest!", currentManifest.getName()));
                    }
                    String newManifestName = this.asicFilenameFactory.getArchiveManifestFilename(mergedASiCContent);
                    currentManifest.setName(newManifestName);
                }
            }
        }
    }

    private void ensureEvidenceRecordManifestDocumentsValid(ASiCContent mergedASiCContent, List<ASiCContent> asicContentsToProcess, ASiCContent asicContent) {
        for (DSSDocument manifest : asicContent.getEvidenceRecordManifestDocuments()) {
            for (ASiCContent currentASiCContent : asicContentsToProcess) {
                for (DSSDocument currentManifest : currentASiCContent.getEvidenceRecordManifestDocuments()) {
                    if (manifest.getName() == null || !manifest.getName().equals(currentManifest.getName()) || Arrays.equals(manifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM), currentManifest.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
                    if (ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), manifest.getName()) || ASiCUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentManifest.getName())) {
                        throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A manifest with name '%s' in a container is covered by another manifest!", currentManifest.getName()));
                    }
                    String newManifestName = this.asicFilenameFactory.getEvidenceRecordManifestFilename(mergedASiCContent);
                    currentManifest.setName(newManifestName);
                }
            }
        }
    }

    private void ensureEvidenceRecordDocumentsValid() {
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getEvidenceRecordDocuments().addAll(asicContent.getEvidenceRecordDocuments());
            mergedASiCContent.getEvidenceRecordManifestDocuments().addAll(asicContent.getEvidenceRecordManifestDocuments());
        }
        ArrayList<ASiCContent> asicContentsToProcess = new ArrayList<ASiCContent>(Arrays.asList(this.asicContents));
        Iterator iterator2 = asicContentsToProcess.iterator();
        while (iterator2.hasNext()) {
            ASiCContent asicContent = (ASiCContent)iterator2.next();
            iterator2.remove();
            for (DSSDocument evidenceRecord : asicContent.getEvidenceRecordDocuments()) {
                for (ASiCContent currentASiCContent : asicContentsToProcess) {
                    for (DSSDocument currentEvidenceRecord : currentASiCContent.getEvidenceRecordDocuments()) {
                        if (evidenceRecord.getName() == null || !evidenceRecord.getName().equals(currentEvidenceRecord.getName()) || Arrays.equals(evidenceRecord.getDigestValue(DEFAULT_DIGEST_ALGORITHM), currentEvidenceRecord.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
                        if (ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), evidenceRecord.getName()) || ASiCUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentEvidenceRecord.getName())) {
                            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. An evidence record with name '%s' in a container is covered by a manifest!", currentEvidenceRecord.getName()));
                        }
                        DSSDocument currentEvidenceRecordManifest = ASiCManifestParser.getLinkedManifest(currentASiCContent.getEvidenceRecordManifestDocuments(), currentEvidenceRecord.getName());
                        if (currentEvidenceRecordManifest == null) {
                            throw new UnsupportedOperationException(String.format("No linked evidence record manifest for an evidence record with filename '%s' has been found!", currentEvidenceRecord.getName()));
                        }
                        EvidenceRecordTypeEnum evidenceRecordType = this.getEvidenceRecordType(currentEvidenceRecord.getName());
                        String newEvidenceRecordName = this.asicFilenameFactory.getEvidenceRecordFilename(mergedASiCContent, evidenceRecordType);
                        currentEvidenceRecord.setName(newEvidenceRecordName);
                        currentEvidenceRecordManifest = this.replaceSigReferenceDocumentName(currentEvidenceRecordManifest, newEvidenceRecordName);
                        ASiCUtils.addOrReplaceDocument(currentASiCContent.getEvidenceRecordManifestDocuments(), currentEvidenceRecordManifest);
                    }
                }
            }
        }
    }

    private EvidenceRecordTypeEnum getEvidenceRecordType(String evidenceRecordFilename) {
        if (ASiCUtils.isXmlEvidenceRecord(evidenceRecordFilename)) {
            return EvidenceRecordTypeEnum.XML_EVIDENCE_RECORD;
        }
        if (ASiCUtils.isAsn1EvidenceRecord(evidenceRecordFilename)) {
            return EvidenceRecordTypeEnum.ASN1_EVIDENCE_RECORD;
        }
        throw new UnsupportedOperationException(String.format("The evidence record with filename '%s' is not supported!", evidenceRecordFilename));
    }

    private DSSDocument replaceSigReferenceDocumentName(DSSDocument evidenceRecordManifest, String newEvidenceRecordName) {
        Document manifestDocumentDom = DomUtils.buildDOM(evidenceRecordManifest);
        Element sigReferenceElement = DomUtils.getElement(manifestDocumentDom.getDocumentElement(), ASiCManifestPath.SIG_REFERENCE_PATH);
        if (sigReferenceElement == null) {
            throw new IllegalArgumentException(String.format("Invalid structure of ASiCEvidenceRecordManifest with name '%s'.", evidenceRecordManifest.getName()));
        }
        sigReferenceElement.setAttribute(ASiCManifestAttribute.URI.getAttributeName(), newEvidenceRecordName);
        byte[] serializedBytes = DomUtils.serializeNode(manifestDocumentDom);
        return new InMemoryDocument(serializedBytes, evidenceRecordManifest.getName(), evidenceRecordManifest.getMimeType());
    }
}

