/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.AbstractASiCWithCAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromFiles;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCManifestBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Collections;

public abstract class ASiCWithCAdESDataToSignHelperBuilder
extends AbstractASiCWithCAdESDataToSignHelperBuilder {
    protected ASiCWithCAdESDataToSignHelperBuilder(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        super(asicFilenameFactory);
    }

    public GetDataToSignASiCWithCAdESHelper build(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (this.isASiCArchive(asicContent = ASiCUtils.ensureMimeTypeAndZipComment(asicContent, parameters.aSiC()))) {
            return this.fromArchive(asicContent, parameters);
        }
        return this.fromFiles(asicContent, parameters);
    }

    private GetDataToSignASiCWithCAdESHelper fromArchive(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        ASiCContainerType currentContainerType = asicContent.getContainerType();
        boolean asice = ASiCUtils.isASiCE(parameters.aSiC());
        if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
            DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
            return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument);
        }
        if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
            return new DataToSignASiCSWithCAdESFromArchive(asicContent);
        }
        throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", new Object[]{currentContainerType, parameters.aSiC().getContainerType()}));
    }

    private GetDataToSignASiCWithCAdESHelper fromFiles(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (ASiCUtils.isASiCE(parameters.aSiC())) {
            asicContent.setContainerType(ASiCContainerType.ASiC_E);
            DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
            return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument);
        }
        asicContent.setContainerType(ASiCContainerType.ASiC_S);
        DSSDocument asicsSignedDocument = this.getASiCSSignedDocument(asicContent.getSignedDocuments(), parameters.getZipCreationDate());
        asicContent.setSignedDocuments(Collections.singletonList(asicsSignedDocument));
        return new DataToSignASiCSWithCAdESFromFiles(asicContent);
    }

    private DSSDocument createManifestDocument(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        return this.getManifestBuilder(asicContent, parameters).build();
    }

    protected abstract AbstractASiCManifestBuilder getManifestBuilder(ASiCContent var1, ASiCWithCAdESCommonParameters var2);
}

