/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilder;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilderFactory;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ZipContentEvidenceRecordDigestBuilder {
    private final List<DSSDocument> documents;
    protected final DigestAlgorithm digestAlgorithm;
    protected DataObjectDigestBuilderFactory dataObjectDigestBuilderFactory;

    protected ZipContentEvidenceRecordDigestBuilder() {
        this(DigestAlgorithm.SHA256);
    }

    protected ZipContentEvidenceRecordDigestBuilder(DigestAlgorithm digestAlgorithm) {
        this.documents = null;
        this.digestAlgorithm = digestAlgorithm;
    }

    public ZipContentEvidenceRecordDigestBuilder(DSSDocument zipContainer) {
        this(zipContainer, DigestAlgorithm.SHA256);
    }

    public ZipContentEvidenceRecordDigestBuilder(DSSDocument zipContainer, DigestAlgorithm digestAlgorithm) {
        this.documents = ZipContentEvidenceRecordDigestBuilder.extractDocuments(zipContainer);
        this.digestAlgorithm = digestAlgorithm;
    }

    private static List<DSSDocument> extractDocuments(DSSDocument zipContainer) {
        return ZipUtils.getInstance().extractContainerContent(zipContainer);
    }

    public ZipContentEvidenceRecordDigestBuilder setDataObjectDigestBuilderFactory(DataObjectDigestBuilderFactory dataObjectDigestBuilderFactory) {
        this.dataObjectDigestBuilderFactory = dataObjectDigestBuilderFactory;
        return this;
    }

    public List<Digest> buildDigestGroup() {
        this.assertConfigurationValid();
        return this.computeDigestForDocuments(this.documents);
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.dataObjectDigestBuilderFactory, "DataObjectDigestBuilderFactory shall be set to continue! Please choose the corresponding implementation for your evidence record type (e.g. XMLERS or ASN.1).");
    }

    protected List<Digest> computeDigestForDocuments(List<DSSDocument> documents) {
        if (Utils.isCollectionEmpty(documents)) {
            return Collections.emptyList();
        }
        ArrayList<Digest> result = new ArrayList<Digest>();
        for (DSSDocument document : documents) {
            DataObjectDigestBuilder dataObjectDigestBuilder = this.dataObjectDigestBuilderFactory.create(document, this.digestAlgorithm);
            Digest digest = dataObjectDigestBuilder.build();
            result.add(digest);
        }
        return result;
    }
}

