/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASiCSignatureExtensionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCSignatureExtensionHelper.class);
    private final ASiCContent asicContent;

    protected ASiCSignatureExtensionHelper(DSSDocument asicContainer) {
        this.asicContent = this.extractAsicContent(asicContainer);
    }

    protected ASiCSignatureExtensionHelper(ASiCContent asicContent) {
        this.asicContent = asicContent;
    }

    private ASiCContent extractAsicContent(DSSDocument asicContainer) {
        if (!ASiCUtils.isASiC(asicContainer)) {
            throw new IllegalInputException("The provided file shall be an ASiC container with signatures inside!");
        }
        DefaultASiCContainerExtractor extractor = this.getASiCContainerExtractor(asicContainer);
        return extractor.extract();
    }

    public ASiCContent getAsicContent() {
        return this.asicContent;
    }

    public DSSDocument extractSignatureDocument(String signatureId) {
        DSSDocument signatureDocument;
        List<DSSDocument> signatureDocuments = this.asicContent.getSignatureDocuments();
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        if (Utils.collectionSize(signatureDocuments) == 1 && this.containsSignatureWithId(signatureDocument = signatureDocuments.get(0), signatureId, true)) {
            this.checkSignatureExtensionPossible(signatureDocument);
            return signatureDocument;
        }
        if (signatureId == null) {
            throw new IllegalArgumentException("More than one signature found in a document! Please provide a signatureId within the parameters.");
        }
        for (DSSDocument signatureDocument2 : signatureDocuments) {
            if (!this.containsSignatureWithId(signatureDocument2, signatureId, false)) continue;
            this.checkSignatureExtensionPossible(signatureDocument2);
            return signatureDocument2;
        }
        throw new IllegalArgumentException(String.format("A signature with id '%s' has not been found!", signatureId));
    }

    public List<DSSDocument> getSignatureDocuments() {
        List<DSSDocument> signatureDocuments = this.asicContent.getSignatureDocuments();
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No supported signature documents found! Unable to extend the container.");
        }
        for (DSSDocument signatureDocument : signatureDocuments) {
            this.checkSignatureExtensionPossible(signatureDocument);
        }
        return signatureDocuments;
    }

    public abstract List<DSSDocument> getDetachedDocuments(String var1);

    public ManifestFile getManifestFile(String signatureFilename) {
        return null;
    }

    protected abstract DefaultASiCContainerExtractor getASiCContainerExtractor(DSSDocument var1);

    protected abstract DocumentAnalyzer getDocumentAnalyzer(DSSDocument var1);

    private boolean containsSignatureWithId(DSSDocument signatureDocument, String signatureId, boolean acceptSingleSignature) {
        try {
            DocumentAnalyzer validator = this.getDocumentAnalyzer(signatureDocument);
            validator.setDetachedContents(this.getDetachedDocuments(signatureDocument.getName()));
            validator.setManifestFile(this.getManifestFile(signatureDocument.getName()));
            List<AdvancedSignature> signatures = validator.getSignatures();
            if (acceptSingleSignature && Utils.collectionSize(signatures) == 1) {
                return true;
            }
            for (AdvancedSignature signature : signatures) {
                if (!this.containsSignatureWithId(signature, signatureId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to verify a file with name '{}'. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, signatureDocument.getName(), e.getMessage(), e);
            }
            LOG.warn(errorMessage, (Object)signatureDocument.getName(), (Object)e.getMessage());
        }
        return false;
    }

    private boolean containsSignatureWithId(AdvancedSignature signature, String signatureId) {
        if (signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier())) {
            return true;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            if (!this.containsSignatureWithId(counterSignature, signatureId)) continue;
            return true;
        }
        return false;
    }

    public void checkSignatureExtensionPossible(DSSDocument signatureDocument) {
        if (ASiCUtils.isCoveredByManifest(this.getAsicContent().getAllManifestDocuments(), signatureDocument.getName())) {
            throw new IllegalInputException(String.format("The modification of the signature is not possible! Reason : a signature with a filename '%s' is covered by another manifest.", signatureDocument.getName()));
        }
    }
}

