/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestValidator;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerAnalyzer;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESFormatDetector;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.extract.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ASiCContainerWithXAdESAnalyzer
extends AbstractASiCContainerAnalyzer {
    ASiCContainerWithXAdESAnalyzer() {
    }

    public ASiCContainerWithXAdESAnalyzer(DSSDocument asicContainer) {
        super(asicContainer);
    }

    public ASiCContainerWithXAdESAnalyzer(ASiCContent asicContent) {
        super(asicContent);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new ASiCWithXAdESFormatDetector().isSupportedASiC(dssDocument);
    }

    @Override
    public boolean isSupported(ASiCContent asicContent) {
        return new ASiCWithXAdESFormatDetector().isSupportedASiC(asicContent);
    }

    @Override
    protected DefaultASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithXAdESContainerExtractor(this.document);
    }

    @Override
    protected List<DocumentAnalyzer> getSignatureAnalyzers() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                XMLDocumentAnalyzer documentAnalyzer = new XMLDocumentAnalyzer(signature);
                documentAnalyzer.setCertificateVerifier(this.certificateVerifier);
                documentAnalyzer.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                if (ASiCUtils.isOpenDocument(this.getMimeTypeDocument())) {
                    documentAnalyzer.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.asicContent));
                } else if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
                    documentAnalyzer.setDetachedContents(this.getSignedDocuments());
                    documentAnalyzer.setContainerContents(this.getArchiveDocuments());
                } else {
                    documentAnalyzer.setDetachedContents(this.getAllDocuments());
                }
                this.signatureValidators.add(documentAnalyzer);
            }
        }
        return this.signatureValidators;
    }

    @Override
    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List<DSSDocument> signatureDocuments = this.getSignatureDocuments();
        List<DSSDocument> manifestDocuments = this.getManifestDocuments();
        for (DSSDocument signatureDoc : signatureDocuments) {
            for (DSSDocument manifestDoc : manifestDocuments) {
                ASiCEWithXAdESManifestParser manifestParser = new ASiCEWithXAdESManifestParser(signatureDoc, manifestDoc);
                descriptions.add(manifestParser.getManifest());
            }
        }
        List<DSSDocument> evidenceRecordManifestDocuments = this.getEvidenceRecordManifestDocuments();
        for (DSSDocument manifestDocument : evidenceRecordManifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.EVIDENCE_RECORD);
            ASiCManifestValidator manifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            manifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature xadesSignature = (XAdESSignature)advancedSignature;
        List<DSSDocument> retrievedDocs = XAdESSignatureUtils.getSignerDocuments(xadesSignature);
        if (Utils.isCollectionNotEmpty(retrievedDocs)) {
            return this.extractArchiveDocuments(retrievedDocs);
        }
        return Collections.emptyList();
    }

    private List<DSSDocument> extractArchiveDocuments(List<DSSDocument> retrievedDocs) {
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        return retrievedDocs;
    }
}

