/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.operator.CustomMessageDigestCalculatorProvider;
import eu.europa.esig.dss.cms.operator.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CAdESUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESUtils.class);
    public static final DigestAlgorithm DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO = DigestAlgorithm.SHA256;
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate(1950, 0, 1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate(2050, 0, 1);
    public static final InMemoryResourcesHandlerBuilder DEFAULT_RESOURCES_HANDLER_BUILDER = new InMemoryResourcesHandlerBuilder();
    private static List<ASN1ObjectIdentifier> timestampOids = new ArrayList<ASN1ObjectIdentifier>();
    private static List<ASN1ObjectIdentifier> evidenceRecordOids;

    private CAdESUtils() {
    }

    public static DERTaggedObject getDERSignedAttributes(SignerInformation signerInformation) {
        try {
            byte[] encodedSignedAttributes = signerInformation.getEncodedSignedAttributes();
            if (encodedSignedAttributes == null) {
                return null;
            }
            ASN1Set asn1Set = (ASN1Set)DSSASN1Utils.toASN1Primitive(encodedSignedAttributes);
            return new DERTaggedObject(false, 0, (ASN1Encodable)asn1Set);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to extract SignedAttributes. Reason : %s", e.getMessage()), e);
        }
    }

    public static AttributeTable getUnsignedAttributes(SignerInformation signerInformation) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        return DSSASN1Utils.emptyIfNull(unsignedAttributes);
    }

    public static AttributeTable getSignedAttributes(SignerInformation signerInformation) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        return DSSASN1Utils.emptyIfNull(signedAttributes);
    }

    public static AttributeTable getAttributesFromByteArray(byte[] encodedAttributes) {
        DLSet dlSet;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(new ByteArrayInputStream(encodedAttributes));){
            dlSet = (DLSet)asn1InputStream.readObject();
        }
        catch (IOException e) {
            throw new DSSException("Error while reading ASN.1 encoded attributes", e);
        }
        return new AttributeTable(dlSet);
    }

    public static void addSigningCertificateAttribute(ASN1EncodableVector signedAttributes, DigestAlgorithm digestAlgorithm, CertificateToken signingToken) {
        Attribute attribute;
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(signingToken);
        byte[] certHash = signingToken.getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Certificate Hash {} with algorithm {}", (Object)Utils.toHex(certHash), (Object)digestAlgorithm.getName());
        }
        if (digestAlgorithm == DigestAlgorithm.SHA1) {
            ESSCertID essCertID = new ESSCertID(certHash, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(signingCertificate));
        } else {
            ESSCertIDv2 essCertIdv2 = DigestAlgorithm.SHA256 == digestAlgorithm ? new ESSCertIDv2(null, certHash, issuerSerial) : new ESSCertIDv2(DSSASN1Utils.getAlgorithmIdentifier(digestAlgorithm), certHash, issuerSerial);
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIdv2);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2));
        }
        signedAttributes.add(attribute);
    }

    public static boolean isCMSSignedDataEqual(CMSSignedData signedData, CMSSignedData signedDataToCompare) throws IOException {
        return Arrays.equals(signedData.getEncoded(), signedDataToCompare.getEncoded());
    }

    public static Attribute getSignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        Object[] attributes = CAdESUtils.getSignedAttributes(signerInformation, oid);
        if (Utils.isArrayEmpty(attributes)) {
            return null;
        }
        if (Utils.arraySize(attributes) > 1) {
            LOG.warn("More than attribute with OID '{}' found in signed attributes table! Value is skipped.", (Object)oid);
            return null;
        }
        return attributes[0];
    }

    public static Attribute[] getSignedAttributes(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable attributeTable = CAdESUtils.getSignedAttributes(signerInformation);
        return DSSASN1Utils.getAsn1Attributes(attributeTable, oid);
    }

    public static Attribute getUnsignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        Object[] attributes = CAdESUtils.getUnsignedAttributes(signerInformation, oid);
        if (Utils.isArrayEmpty(attributes)) {
            return null;
        }
        if (Utils.arraySize(attributes) > 1) {
            LOG.warn("More than attribute with OID '{}' found in unsigned attributes table! Value is skipped.", (Object)oid);
            return null;
        }
        return attributes[0];
    }

    public static Attribute[] getUnsignedAttributes(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable attributeTable = CAdESUtils.getUnsignedAttributes(signerInformation);
        return DSSASN1Utils.getAsn1Attributes(attributeTable, oid);
    }

    public static DSSDocument getOriginalDocument(CMS cms, List<DSSDocument> detachedDocuments) {
        Objects.requireNonNull(cms, "CMS shall be provided!");
        if (!cms.isDetachedSignature()) {
            DSSDocument signedContent = cms.getSignedContent();
            if (signedContent == null) {
                throw new DSSException("No signed content found within enveloping CMS signature!");
            }
            return signedContent;
        }
        if (Utils.collectionSize(detachedDocuments) == 1) {
            return detachedDocuments.get(0);
        }
        throw new DSSException("Detached content is not provided or cannot be identified (only one document shall be provided)!");
    }

    @Deprecated
    public static DigestCalculatorProvider getDigestCalculatorProvider(DSSDocument toSignDocument, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            return new CustomMessageDigestCalculatorProvider(digestAlgorithm, toSignDocument.getDigestValue(digestAlgorithm));
        }
        if (toSignDocument instanceof DigestDocument) {
            return new PrecomputedDigestCalculatorProvider(toSignDocument);
        }
        return new BcDigestCalculatorProvider();
    }

    public static boolean containsATSTv2(SignerInformation signerInformation) {
        Attribute[] attributes;
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            if (!DSSASN1Utils.isAttributeOfType(attribute, OID.id_aa_ets_archiveTimestampV2)) continue;
            return true;
        }
        return false;
    }

    public static Date readSigningDate(ASN1Encodable attrValue) {
        if (attrValue != null) {
            Date signingDate = DSSASN1Utils.getDate(attrValue);
            if (signingDate != null) {
                if (signingDate.compareTo(JANUARY_1950) >= 0 && signingDate.before(JANUARY_2050) && !(attrValue.toASN1Primitive() instanceof ASN1UTCTime)) {
                    LOG.warn("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) MUST be encoded as UTCTime. Any dates with year values before 1950 or after 2049 MUST be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, (Object)attrValue.getClass());
                    return null;
                }
                return signingDate;
            }
            LOG.warn("Error when reading signing time. Unrecognized {}", (Object)attrValue.getClass());
        }
        return null;
    }

    public static List<TimeStampToken> findArchiveTimeStampTokens(AttributeTable unsignedAttributes) {
        Attribute[] attributes;
        ArrayList<TimeStampToken> timeStamps = new ArrayList<TimeStampToken>();
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            TimeStampToken timeStampToken;
            if (!CAdESUtils.isArchiveTimeStampToken(attribute) || (timeStampToken = CAdESUtils.getTimeStampToken(attribute)) == null) continue;
            timeStamps.add(timeStampToken);
        }
        return timeStamps;
    }

    public static List<ASN1ObjectIdentifier> getTimestampOids() {
        return timestampOids;
    }

    public static boolean isArchiveTimeStampToken(Attribute attribute) {
        ASN1ObjectIdentifier attrOid = attribute.getAttrType();
        if (attrOid != null) {
            return TimestampType.ARCHIVE_TIMESTAMP == CAdESUtils.getTimestampTypeByOid(attrOid);
        }
        return false;
    }

    public static TimestampType getTimestampTypeByOid(ASN1ObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals(oid)) {
            return TimestampType.CONTENT_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals(oid)) {
            return TimestampType.SIGNATURE_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals(oid)) {
            return TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals(oid)) {
            return TimestampType.VALIDATION_DATA_TIMESTAMP;
        }
        if (OID.id_aa_ets_archiveTimestampV2.equals(oid) || OID.id_aa_ets_archiveTimestampV3.equals(oid)) {
            return TimestampType.ARCHIVE_TIMESTAMP;
        }
        return null;
    }

    public static ASN1Sequence getAtsHashIndex(AttributeTable timestampUnsignedAttributes) {
        ASN1ObjectIdentifier atsHashIndexVersionIdentifier = CAdESUtils.getAtsHashIndexVersionIdentifier(timestampUnsignedAttributes);
        return CAdESUtils.getAtsHashIndexByVersion(timestampUnsignedAttributes, atsHashIndexVersionIdentifier);
    }

    public static ASN1Sequence getCertificatesHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int certificateIndex = 0;
            if (atsHashIndexValue.size() > 3) {
                ++certificateIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(certificateIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getCRLHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int crlIndex = 1;
            if (atsHashIndexValue.size() > 3) {
                ++crlIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(crlIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getUnsignedAttributesHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int unsignedAttributesIndex = 2;
            if (atsHashIndexValue.size() > 3) {
                ++unsignedAttributesIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(unsignedAttributesIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getAtsHashIndexByVersion(AttributeTable timestampUnsignedAttributes, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        Object atsHashIndexAttribute;
        ASN1Encodable attrValue;
        Object[] attributes;
        if (timestampUnsignedAttributes != null && atsHashIndexVersionIdentifier != null && Utils.arraySize(attributes = DSSASN1Utils.getAsn1Attributes(timestampUnsignedAttributes, atsHashIndexVersionIdentifier)) == 1 && (attrValue = DSSASN1Utils.getAsn1Encodable((Attribute)(atsHashIndexAttribute = attributes[0]))) != null) {
            return (ASN1Sequence)attrValue.toASN1Primitive();
        }
        return null;
    }

    public static ASN1ObjectIdentifier getAtsHashIndexVersionIdentifier(AttributeTable timestampUnsignedAttributes) {
        if (timestampUnsignedAttributes != null) {
            Attributes attributes = timestampUnsignedAttributes.toASN1Structure();
            for (Attribute attribute : attributes.getAttributes()) {
                ASN1ObjectIdentifier attrType = attribute.getAttrType();
                if (!OID.id_aa_ATSHashIndex.equals(attrType) && !OID.id_aa_ATSHashIndexV2.equals(attrType) && !OID.id_aa_ATSHashIndexV3.equals(attrType)) continue;
                LOG.debug("Unsigned attribute of type [{}] found in the timestamp.", (Object)attrType);
                return attrType;
            }
            LOG.warn("The timestamp unsignedAttributes does not contain ATSHashIndex!");
        }
        return null;
    }

    public static List<byte[]> getOctetStringForAtsHashIndex(Attribute attribute, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        if (OID.id_aa_ATSHashIndexV3.equals(atsHashIndexVersionIdentifier)) {
            return CAdESUtils.getATSHashIndexV3OctetString(attribute.getAttrType(), attribute.getAttrValues());
        }
        return Collections.singletonList(DSSASN1Utils.getDEREncoded(attribute));
    }

    public static List<byte[]> getATSHashIndexV3OctetString(ASN1ObjectIdentifier attributeIdentifier, ASN1Set attributeValues) {
        ArrayList<byte[]> octets = new ArrayList<byte[]>();
        byte[] attrType = DSSASN1Utils.getDEREncoded(attributeIdentifier);
        for (ASN1Encodable asn1Encodable : attributeValues.toArray()) {
            octets.add(Utils.concat(attrType, DSSASN1Utils.getDEREncoded(asn1Encodable)));
        }
        return octets;
    }

    public static List<ASN1ObjectIdentifier> getEvidenceRecordOids() {
        return evidenceRecordOids;
    }

    public static EvidenceRecordIncorporationType getEvidenceRecordIncorporationType(ASN1ObjectIdentifier unsignedAttributeOID) {
        if (OID.id_aa_er_internal.equals(unsignedAttributeOID)) {
            return EvidenceRecordIncorporationType.INTERNAL_EVIDENCE_RECORD;
        }
        if (OID.id_aa_er_external.equals(unsignedAttributeOID)) {
            return EvidenceRecordIncorporationType.EXTERNAL_EVIDENCE_RECORD;
        }
        throw new UnsupportedOperationException(String.format("The unsigned attribute with OID '%s' is not supported for the evidence record incorporation!", unsignedAttributeOID.getId()));
    }

    public static boolean containsEvidenceRecord(SignerInformation signerInformation) {
        if (signerInformation != null && signerInformation.getUnsignedAttributes() != null) {
            return signerInformation.getUnsignedAttributes().get(OID.id_aa_er_internal) != null || signerInformation.getUnsignedAttributes().get(OID.id_aa_er_external) != null;
        }
        return false;
    }

    public static Date getEvidenceRecordGenerationTime(EvidenceRecord evidenceRecord) {
        ContentInfo contentInfo;
        TimeStampToken timeStampToken;
        Object[] archiveTimestamps;
        Object[] archiveTimeStampChains;
        ArchiveTimeStampSequence archiveTimeStampSequence;
        if (evidenceRecord != null && (archiveTimeStampSequence = evidenceRecord.getArchiveTimeStampSequence()) != null && Utils.isArrayNotEmpty(archiveTimeStampChains = archiveTimeStampSequence.getArchiveTimeStampChains()) && Utils.isArrayNotEmpty(archiveTimestamps = ((ArchiveTimeStampChain)archiveTimeStampChains[0]).getArchiveTimestamps()) && (timeStampToken = CAdESUtils.toTimeStampToken(contentInfo = ((ArchiveTimeStamp)archiveTimestamps[0]).getTimeStamp())) != null) {
            return timeStampToken.getTimeStampInfo().getGenTime();
        }
        return null;
    }

    private static TimeStampToken toTimeStampToken(ContentInfo contentInfo) {
        if (contentInfo != null) {
            try {
                return new TimeStampToken(contentInfo);
            }
            catch (IOException | TSPException e) {
                throw new DSSException(String.format("Unable to build a timestamp token : %s", e.getMessage()), e);
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isEmpty(AttributeTable attributeTable) {
        return attributeTable == null || attributeTable.size() == 0;
    }

    @Deprecated
    public static AttributeTable emptyIfNull(AttributeTable originalAttributeTable) {
        if (originalAttributeTable != null) {
            return originalAttributeTable;
        }
        return new AttributeTable(new Hashtable());
    }

    @Deprecated
    public static boolean isAttributeOfType(Attribute attribute, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        if (attribute == null) {
            return false;
        }
        ASN1ObjectIdentifier objectIdentifier = attribute.getAttrType();
        return asn1ObjectIdentifier.equals(objectIdentifier);
    }

    public static TimeStampToken getTimeStampToken(Attribute attribute) {
        try {
            CMSSignedData signedData = CAdESUtils.getCMSSignedData(attribute);
            if (signedData != null) {
                return new TimeStampToken(signedData);
            }
        }
        catch (IOException | CMSException | TSPException e) {
            LOG.warn("The given TimeStampToken cannot be created! Reason: [{}]", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public static CMSSignedData getCMSSignedData(Attribute attribute) throws CMSException, IOException {
        ASN1Encodable value = DSSASN1Utils.getAsn1Encodable(attribute);
        if (!(value instanceof DEROctetString)) {
            ASN1Primitive asn1Primitive = value.toASN1Primitive();
            return new CMSSignedData(asn1Primitive.getEncoded());
        }
        LOG.warn("Illegal content for CMSSignedData (OID : {}) : OCTET STRING is not allowed !", (Object)attribute.getAttrType());
        return null;
    }

    public static byte[] getEncodedValue(Attribute attribute) throws IOException {
        ASN1Encodable value = DSSASN1Utils.getAsn1Encodable(attribute);
        ASN1Primitive asn1Primitive = value.toASN1Primitive();
        return asn1Primitive.getEncoded();
    }

    public static byte[] getSignedDataEncodedOCSPResponse(byte[] binaries, ASN1ObjectIdentifier objectIdentifier) {
        OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(objectIdentifier, (ASN1Encodable)DSSASN1Utils.toASN1Primitive(binaries));
        DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)otherRevocationInfoFormat);
        return DSSASN1Utils.getDEREncoded(derTaggedObject);
    }

    static {
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp);
        timestampOids.add(OID.id_aa_ets_archiveTimestampV2);
        timestampOids.add(OID.id_aa_ets_archiveTimestampV3);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        evidenceRecordOids = new ArrayList<ASN1ObjectIdentifier>();
        evidenceRecordOids.add(OID.id_aa_er_internal);
        evidenceRecordOids.add(OID.id_aa_er_external);
    }
}

