/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSBuilder;
import eu.europa.esig.dss.cms.CMSSignerInfoGeneratorBuilder;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import java.util.Objects;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.operator.ContentSigner;

public class CMSForCAdESBuilderHelper {
    protected final DSSDocument documentToSign;
    protected final CAdESSignatureParameters signatureParameters;
    protected final ContentSigner contentSigner;
    private CMS originalCMS;
    private CertificateSource trustedCertificateSource;
    private boolean includeUnsignedAttributes;
    private CAdESLevelBaselineB cadesProfile;

    public CMSForCAdESBuilderHelper(DSSDocument documentToSign, CAdESSignatureParameters signatureParameters, ContentSigner contentSigner) {
        Objects.requireNonNull(documentToSign, "documentToSign cannot be null!");
        Objects.requireNonNull(signatureParameters, "signatureParameters cannot be null!");
        Objects.requireNonNull(contentSigner, "contentSigner cannot be null!");
        this.documentToSign = documentToSign;
        this.signatureParameters = signatureParameters;
        this.contentSigner = contentSigner;
    }

    public CMSForCAdESBuilderHelper setOriginalCMS(CMS originalCMS) {
        this.originalCMS = originalCMS;
        return this;
    }

    public CMSForCAdESBuilderHelper setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
        return this;
    }

    public CMSForCAdESBuilderHelper setIncludeUnsignedAttributes(boolean includeUnsignedAttributes) {
        this.includeUnsignedAttributes = includeUnsignedAttributes;
        return this;
    }

    public CMS createCMS() {
        Objects.requireNonNull(this.contentSigner, "contentSigner cannot be null!");
        CMSBuilder cmsBuilder = this.initCMSBuilder();
        SignerInfoGenerator signerInfoGenerator = this.createSignerInfoGenerator();
        return cmsBuilder.createCMS(signerInfoGenerator, this.documentToSign);
    }

    public SignerInfoGenerator createSignerInfoGenerator() {
        this.assertSignatureParametersValid();
        AttributeTable signedAttributes = this.initSignedAttributesTable();
        AttributeTable unsignedAttributes = this.initUnsignedAttributesTable();
        CMSSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.createCMSSignerInfoGeneratorBuilder(signedAttributes, unsignedAttributes);
        return signerInfoGeneratorBuilder.build(this.documentToSign, this.contentSigner);
    }

    protected AttributeTable initSignedAttributesTable() {
        CAdESLevelBaselineB cadesProfile = this.getCAdESProfile();
        return cadesProfile.getSignedAttributes(this.signatureParameters);
    }

    protected AttributeTable initUnsignedAttributesTable() {
        if (this.includeUnsignedAttributes) {
            CAdESLevelBaselineB cadesProfile = this.getCAdESProfile();
            return cadesProfile.getUnsignedAttributes();
        }
        return null;
    }

    protected CAdESLevelBaselineB getCAdESProfile() {
        if (this.cadesProfile == null) {
            this.cadesProfile = this.initCAdESProfile();
        }
        return this.cadesProfile;
    }

    protected CAdESLevelBaselineB initCAdESProfile() {
        return new CAdESLevelBaselineB(this.documentToSign);
    }

    protected CMSSignerInfoGeneratorBuilder createCMSSignerInfoGeneratorBuilder(AttributeTable signedAttributes, AttributeTable unsignedAttributes) {
        return this.initCMSSignerInfoGeneratorBuilder().setSigningCertificate(this.signatureParameters.getSigningCertificate()).setDigestAlgorithm(this.signatureParameters.getReferenceDigestAlgorithm()).setSignedAttributes(signedAttributes).setUnsignedAttributes(unsignedAttributes);
    }

    protected CMSSignerInfoGeneratorBuilder initCMSSignerInfoGeneratorBuilder() {
        return new CMSSignerInfoGeneratorBuilder();
    }

    protected void assertSignatureParametersValid() {
        if (this.signatureParameters.getSigningCertificate() == null && !this.signatureParameters.isGenerateTBSWithoutCertificate()) {
            throw new IllegalArgumentException("Signing-certificate is not provided! Use #setGenerateWithoutCertificates(true) method.");
        }
    }

    protected CMSBuilder initCMSBuilder() {
        return new CMSBuilder().setSigningCertificate(this.signatureParameters.getSigningCertificate()).setCertificateChain(this.signatureParameters.getCertificateChain()).setGenerateWithoutCertificates(this.signatureParameters.isGenerateTBSWithoutCertificate()).setTrustAnchorBPPolicy(this.signatureParameters.bLevel().isTrustAnchorBPPolicy()).setTrustedCertificateSource(this.trustedCertificateSource).setEncapsulate(this.isEncapsulateSignerData()).setOriginalCMS(this.originalCMS);
    }

    protected boolean isEncapsulateSignerData() {
        return !SignaturePackaging.DETACHED.equals((Object)this.signatureParameters.getSignaturePackaging());
    }
}

