/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class CMSSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public CMSSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? new Hashtable(attributeTable.toHashtable()) : new Hashtable();
    }

    @Override
    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        ASN1ObjectIdentifier contentType;
        if (!this.table.containsKey(CMSAttributes.contentType) && (contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"))) != null) {
            attr = new Attribute(CMSAttributes.contentType, new DERSet(contentType));
            this.table.put(attr.getAttrType(), attr);
        }
        if (!this.table.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(messageDigest)));
            this.table.put(attr.getAttrType(), attr);
        }
        if (!this.table.contains(CMSAttributes.cmsAlgorithmProtect)) {
            Attribute attr2 = new Attribute(CMSAttributes.cmsAlgorithmProtect, new DERSet(new CMSAlgorithmProtection((AlgorithmIdentifier)parameters.get("digestAlgID"), 1, (AlgorithmIdentifier)parameters.get("signatureAlgID"))));
            this.table.put(attr2.getAttrType(), attr2);
        }
        return this.table;
    }
}

