/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.ICMSUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Store;

public final class CMSUtils {
    private static ICMSUtils impl;

    private CMSUtils() {
    }

    public static CMS parseToCMS(DSSDocument document) {
        return impl.parseToCMS(document);
    }

    public static CMS parseToCMS(byte[] binaries) {
        return impl.parseToCMS(binaries);
    }

    public static DSSDocument writeToDSSDocument(CMS cms, DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        return impl.writeToDSSDocument(cms, resourcesHandlerBuilder);
    }

    public static SignerInformation recomputeSignerInformation(CMS cms, SignerId signerId, DigestCalculatorProvider digestCalculatorProvider, DSSResourcesHandlerBuilder resourcesHandlerBuilder) throws CMSException {
        return impl.recomputeSignerInformation(cms, signerId, digestCalculatorProvider, resourcesHandlerBuilder);
    }

    public static CMS replaceSigners(CMS cms, SignerInformationStore newSignerStore) {
        return impl.replaceSigners(cms, newSignerStore);
    }

    public static CMS replaceCertificatesAndCRLs(CMS cms, Store<X509CertificateHolder> certificates, Store<X509AttributeCertificateHolder> attributeCertificates, Store<X509CRLHolder> crls, Store<?> ocspResponsesStore, Store<?> ocspBasicStore) {
        return impl.replaceCertificatesAndCRLs(cms, certificates, attributeCertificates, crls, ocspResponsesStore, ocspBasicStore);
    }

    public static CMS populateDigestAlgorithmSet(CMS cms, Collection<AlgorithmIdentifier> digestAlgorithmsToAdd) {
        return impl.populateDigestAlgorithmSet(cms, digestAlgorithmsToAdd);
    }

    public static CMS toCMS(TimeStampToken timeStampToken) {
        return impl.toCMS(timeStampToken);
    }

    public static String getContentInfoEncoding(CMS cms) {
        return impl.getContentInfoEncoding(cms);
    }

    public static void writeSignedDataDigestAlgorithmsEncoded(CMS cms, OutputStream os) throws IOException {
        impl.writeSignedDataDigestAlgorithmsEncoded(cms, os);
    }

    public static void writeContentInfoEncoded(CMS cms, OutputStream os) throws IOException {
        impl.writeContentInfoEncoded(cms, os);
    }

    public static void writeSignedDataCertificatesEncoded(CMS cms, OutputStream os) throws IOException {
        impl.writeSignedDataCertificatesEncoded(cms, os);
    }

    public static void writeSignedDataCRLsEncoded(CMS cms, OutputStream os) throws IOException {
        impl.writeSignedDataCRLsEncoded(cms, os);
    }

    public static void writeSignedDataSignerInfosEncoded(CMS cms, OutputStream os) throws IOException {
        impl.writeSignedDataSignerInfosEncoded(cms, os);
    }

    public static CMSTypedData toCMSEncapsulatedContent(DSSDocument document) {
        return impl.toCMSEncapsulatedContent(document);
    }

    public static DSSResourcesHandlerBuilder getDSSResourcesHandlerBuilder(DSSResourcesHandlerBuilder dssResourcesHandlerBuilder) {
        return impl.getDSSResourcesHandlerBuilder(dssResourcesHandlerBuilder);
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable unsignedAttributes) {
        return impl.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
    }

    public static void assertATSv2AugmentationSupported() {
        impl.assertATSv2AugmentationSupported();
    }

    public static void assertEvidenceRecordEmbeddingSupported() {
        impl.assertEvidenceRecordEmbeddingSupported();
    }

    static {
        ServiceLoader<ICMSUtils> loader = ServiceLoader.load(ICMSUtils.class);
        Iterator<ICMSUtils> iterator2 = loader.iterator();
        if (!iterator2.hasNext()) {
            throw new ExceptionInInitializerError("No implementation found for ICMSUtils in classpath, please choose between dss-cms-object or dss-cms-stream");
        }
        impl = iterator2.next();
    }
}

