/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractSignatureWrapper;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.PDFRevisionWrapper;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundEvidenceRecord;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSPDocSpecification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignaturePolicyStore;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlUserNotice;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SignatureWrapper
extends AbstractSignatureWrapper {
    private final XmlSignature signature;

    public SignatureWrapper(XmlSignature signature) {
        Objects.requireNonNull(signature, "XmlSignature cannot be null!");
        this.signature = signature;
    }

    @Override
    public String getId() {
        return this.signature.getId();
    }

    public String getDAIdentifier() {
        return this.signature.getDAIdentifier();
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return this.signature.getDigestMatchers();
    }

    public XmlDigestMatcher getMessageDigest() {
        List<XmlDigestMatcher> digestMatchers = this.signature.getDigestMatchers();
        for (XmlDigestMatcher xmlDigestMatcher : digestMatchers) {
            if (DigestMatcherType.MESSAGE_DIGEST != xmlDigestMatcher.getType()) continue;
            return xmlDigestMatcher;
        }
        return null;
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.signature.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.signature.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.signature.getSigningCertificate();
    }

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(this.signature.getFoundCertificates());
    }

    @Override
    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(this.signature.getFoundRevocations());
    }

    @Override
    public String getFilename() {
        return this.signature.getSignatureFilename();
    }

    public boolean isStructuralValidationValid() {
        return this.signature.getStructuralValidation() != null && this.signature.getStructuralValidation().isValid();
    }

    public List<String> getStructuralValidationMessages() {
        XmlStructuralValidation structuralValidation = this.signature.getStructuralValidation();
        if (structuralValidation != null) {
            return structuralValidation.getMessages();
        }
        return Collections.emptyList();
    }

    public Date getClaimedSigningTime() {
        return this.signature.getClaimedSigningTime();
    }

    public Date getExpirationTime() {
        return this.signature.getExpirationTime();
    }

    public String getContentType() {
        return this.signature.getContentType();
    }

    public String getMimeType() {
        return this.signature.getMimeType();
    }

    public String getContentHints() {
        return this.signature.getContentHints();
    }

    public String getContentIdentifier() {
        return this.signature.getContentIdentifier();
    }

    public boolean isCounterSignature() {
        return this.signature.isCounterSignature() != null && this.signature.isCounterSignature() != false;
    }

    public boolean isSignatureDuplicated() {
        return this.signature.isDuplicated() != null && this.signature.isDuplicated() != false;
    }

    public XmlSignatureDigestReference getSignatureDigestReference() {
        return this.signature.getSignatureDigestReference();
    }

    public XmlDigestAlgoAndValue getDataToBeSignedRepresentation() {
        return this.signature.getDataToBeSignedRepresentation();
    }

    public List<TimestampWrapper> getTimestampList() {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List<XmlFoundTimestamp> foundTimestamps = this.signature.getFoundTimestamps();
        for (XmlFoundTimestamp xmlFoundTimestamp : foundTimestamps) {
            tsps.add(new TimestampWrapper(xmlFoundTimestamp.getTimestamp()));
        }
        return tsps;
    }

    public List<TimestampWrapper> getTimestampListByType(TimestampType timestampType) {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        List<TimestampWrapper> all = this.getTimestampList();
        for (TimestampWrapper tsp : all) {
            if (!timestampType.equals((Object)tsp.getType())) continue;
            result.add(tsp);
        }
        return result;
    }

    public List<EvidenceRecordWrapper> getEvidenceRecords() {
        ArrayList<EvidenceRecordWrapper> evidenceRecords = new ArrayList<EvidenceRecordWrapper>();
        List<XmlFoundEvidenceRecord> foundEvidenceRecords = this.signature.getFoundEvidenceRecords();
        for (XmlFoundEvidenceRecord xmlFoundEvidenceRecord : foundEvidenceRecords) {
            evidenceRecords.add(new EvidenceRecordWrapper(xmlFoundEvidenceRecord.getEvidenceRecord()));
        }
        return evidenceRecords;
    }

    public List<String> getEvidenceRecordIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        for (EvidenceRecordWrapper evidenceRecordWrapper : this.getEvidenceRecords()) {
            result.add(evidenceRecordWrapper.getId());
        }
        return result;
    }

    public List<String> getEvidenceRecordTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (EvidenceRecordWrapper evidenceRecordWrapper : this.getEvidenceRecords()) {
            result.addAll(evidenceRecordWrapper.getTimestampIdsList());
        }
        return result;
    }

    public List<EvidenceRecordWrapper> getEmbeddedEvidenceRecords() {
        ArrayList<EvidenceRecordWrapper> embeddedEvidenceRecords = new ArrayList<EvidenceRecordWrapper>();
        for (EvidenceRecordWrapper evidenceRecord : this.getEvidenceRecords()) {
            if (!evidenceRecord.isEmbedded()) continue;
            embeddedEvidenceRecords.add(evidenceRecord);
        }
        return embeddedEvidenceRecords;
    }

    public boolean isSignatureProductionPlacePresent() {
        return this.signature.getSignatureProductionPlace() != null;
    }

    public String getStreetAddress() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getStreetAddress();
        }
        return null;
    }

    public String getCity() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getCity();
        }
        return null;
    }

    public String getCountryName() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getCountryName();
        }
        return null;
    }

    public String getPostOfficeBoxNumber() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostOfficeBoxNumber();
        }
        return null;
    }

    public String getPostalCode() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostalCode();
        }
        return null;
    }

    public String getStateOrProvince() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getStateOrProvince();
        }
        return null;
    }

    public List<String> getPostalAddress() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostalAddress();
        }
        return Collections.emptyList();
    }

    public SignatureLevel getSignatureFormat() {
        return this.signature.getSignatureFormat();
    }

    public String getSignatureType() {
        return this.signature.getSignatureType();
    }

    public JWSSerializationType getJWSSerializationType() {
        return this.signature.getJWSSerializationType();
    }

    public String getErrorMessage() {
        return this.signature.getErrorMessage();
    }

    public boolean isSigningCertificateIdentified() {
        CertificateWrapper signingCertificate = this.getSigningCertificate();
        CertificateRefWrapper signingCertificateReference = this.getSigningCertificateReference();
        if (signingCertificate != null && signingCertificateReference != null) {
            return signingCertificateReference.isDigestValueMatch() && (!signingCertificateReference.isIssuerSerialPresent() || signingCertificateReference.isIssuerSerialMatch());
        }
        return false;
    }

    public String getPolicyId() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getId();
        }
        return "";
    }

    public boolean isPolicyZeroHash() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isZeroHash() != null && policy.getDigestAlgoAndValue().isZeroHash() != false;
        }
        return false;
    }

    public XmlPolicyDigestAlgoAndValue getPolicyDigestAlgoAndValue() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getDigestAlgoAndValue();
        }
        return null;
    }

    public boolean isPolicyStorePresent() {
        return this.signature.getSignaturePolicyStore() != null;
    }

    public String getPolicyStoreId() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getId();
        }
        return null;
    }

    public String getPolicyStoreDescription() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDescription();
        }
        return null;
    }

    public XmlDigestAlgoAndValue getPolicyStoreDigestAlgoAndValue() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDigestAlgoAndValue();
        }
        return null;
    }

    public List<String> getPolicyStoreDocumentationReferences() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDocumentationReferences();
        }
        return Collections.emptyList();
    }

    public String getPolicyStoreLocalURI() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getSigPolDocLocalURI();
        }
        return null;
    }

    public boolean isBLevelTechnicallyValid() {
        return this.isSignatureValid();
    }

    public boolean isThereXLevel() {
        List<TimestampWrapper> timestampLevelX = this.getTimestampLevelX();
        return timestampLevelX != null && !timestampLevelX.isEmpty();
    }

    public boolean isXLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTimestampLevelX();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getTimestampLevelX() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.VALIDATION_DATA_TIMESTAMP));
        return timestamps;
    }

    public boolean isThereALevel() {
        List<TimestampWrapper> timestamps = this.getALevelTimestamps();
        return timestamps != null && !timestamps.isEmpty();
    }

    public boolean isALevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getALevelTimestamps();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getALevelTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>(this.getArchiveTimestamps());
        timestamps.addAll(this.getDocumentTimestamps(true));
        timestamps.addAll(this.getContainerTimestamps());
        return timestamps;
    }

    public List<TimestampWrapper> getArchiveTimestamps() {
        return this.getTimestampListByType(TimestampType.ARCHIVE_TIMESTAMP);
    }

    public boolean isThereTLevel() {
        List<TimestampWrapper> timestamps = this.getTLevelTimestamps();
        return timestamps != null && !timestamps.isEmpty();
    }

    public boolean isTLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTLevelTimestamps();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getTLevelTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>(this.getSignatureTimestamps());
        timestamps.addAll(this.getDocumentTimestamps());
        return timestamps;
    }

    public List<TimestampWrapper> getContentTimestamps() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP));
        timestamps.addAll(this.getTimestampListByType(TimestampType.ALL_DATA_OBJECTS_TIMESTAMP));
        return timestamps;
    }

    public List<TimestampWrapper> getAllTimestampsProducedAfterSignatureCreation() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>();
        for (TimestampType timestampType : TimestampType.values()) {
            if (timestampType.isContentTimestamp()) continue;
            timestamps.addAll(this.getTimestampListByType(timestampType));
        }
        return timestamps;
    }

    public List<TimestampWrapper> getSignatureTimestamps() {
        return this.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
    }

    public List<TimestampWrapper> getDocumentTimestamps() {
        return this.getTimestampListByType(TimestampType.DOCUMENT_TIMESTAMP);
    }

    public List<TimestampWrapper> getContainerTimestamps() {
        return this.getTimestampListByType(TimestampType.CONTAINER_TIMESTAMP);
    }

    public List<TimestampWrapper> getVRITimestamps() {
        return this.getTimestampListByType(TimestampType.VRI_TIMESTAMP);
    }

    private List<TimestampWrapper> getDocumentTimestamps(boolean coversLTLevel) {
        ArrayList<TimestampWrapper> timestampWrappers = new ArrayList<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : this.getDocumentTimestamps()) {
            if (coversLTLevel != this.coversLTLevel(timestampWrapper)) continue;
            timestampWrappers.add(timestampWrapper);
        }
        return timestampWrappers;
    }

    private boolean coversLTLevel(TimestampWrapper timestampWrapper) {
        if (ArchiveTimestampType.PAdES.equals((Object)timestampWrapper.getArchiveTimestampType())) {
            List<CertificateWrapper> signatureCertificateChain = this.getCertificateChain();
            List<RelatedRevocationWrapper> relatedRevocationData = this.foundRevocations().getRelatedRevocationData();
            if (relatedRevocationData == null || relatedRevocationData.isEmpty()) {
                return this.coversDSSCertificateDataForCertificateChain(timestampWrapper, signatureCertificateChain);
            }
            return this.coversRevocationDataForCertificateChain(timestampWrapper, signatureCertificateChain) && (this.coversTimestampTokens(timestampWrapper, this.getTimestampList()) || this.coversOwnRevocationData(timestampWrapper));
        }
        return false;
    }

    private boolean coversDSSCertificateDataForCertificateChain(TimestampWrapper timestampWrapper, List<CertificateWrapper> certificateChain) {
        ArrayList<RelatedCertificateWrapper> dssCertificates = new ArrayList<RelatedCertificateWrapper>();
        dssCertificates.addAll(this.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.DSS_DICTIONARY));
        dssCertificates.addAll(this.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.VRI_DICTIONARY));
        if (!dssCertificates.isEmpty()) {
            List<CertificateWrapper> timestampedCertificates = timestampWrapper.getTimestampedCertificates();
            for (CertificateWrapper certificateWrapper : certificateChain) {
                if (!dssCertificates.contains(certificateWrapper) || !timestampedCertificates.contains(certificateWrapper)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean coversRevocationDataForCertificateChain(TimestampWrapper timestampWrapper, List<CertificateWrapper> certificateChain) {
        List<RevocationWrapper> timestampedRevocations = timestampWrapper.getTimestampedRevocations();
        for (CertificateWrapper certificateWrapper : certificateChain) {
            List<CertificateRevocationWrapper> certificateRevocationData = certificateWrapper.getCertificateRevocationData();
            if (certificateRevocationData == null || certificateRevocationData.isEmpty()) continue;
            return certificateRevocationData.stream().anyMatch(timestampedRevocations::contains);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean coversTimestampTokens(TimestampWrapper timestamp, List<TimestampWrapper> timestampWrappers) {
        List<TimestampWrapper> timestampedTimestamps = timestamp.getTimestampedTimestamps();
        if (timestampedTimestamps == null) return false;
        if (!timestampWrappers.stream().anyMatch(timestampedTimestamps::contains)) return false;
        return true;
    }

    private boolean coversOwnRevocationData(TimestampWrapper timestampWrapper) {
        CertificateWrapper signingCertificate = timestampWrapper.getSigningCertificate();
        if (signingCertificate.isSelfSigned() || signingCertificate.isTrusted()) {
            return true;
        }
        return this.coversRevocationDataForCertificateChain(timestampWrapper, timestampWrapper.getCertificateChain());
    }

    private boolean isAtLeastOneTimestampValid(List<TimestampWrapper> timestampList) {
        if (timestampList != null && !timestampList.isEmpty()) {
            for (TimestampWrapper timestamp : timestampList) {
                boolean messageImprintIntact;
                boolean signatureValid = timestamp.isSignatureValid();
                XmlDigestMatcher messageImprint = timestamp.getMessageImprint();
                boolean bl = messageImprintIntact = messageImprint.isDataFound() && messageImprint.isDataIntact();
                if (!signatureValid || !messageImprintIntact) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTimestampIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        List<TimestampWrapper> timestamps = this.getTimestampList();
        if (timestamps != null) {
            for (TimestampWrapper tsp : timestamps) {
                result.add(tsp.getId());
            }
        }
        return result;
    }

    public boolean isThereERSLevel() {
        List<EvidenceRecordWrapper> embeddedEvidenceRecords = this.getEmbeddedEvidenceRecords();
        return embeddedEvidenceRecords != null && !embeddedEvidenceRecords.isEmpty();
    }

    public CertificateRefWrapper getKeyIdentifierReference() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        certificateRefs.addAll(this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.KEY_IDENTIFIER));
        certificateRefs.addAll(this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.KEY_IDENTIFIER));
        if (!certificateRefs.isEmpty()) {
            return (CertificateRefWrapper)certificateRefs.iterator().next();
        }
        return null;
    }

    public SignatureWrapper getParent() {
        XmlSignature parent = this.signature.getParent();
        if (parent != null) {
            return new SignatureWrapper(parent);
        }
        return null;
    }

    public List<XmlSignatureScope> getSignatureScopes() {
        return this.signature.getSignatureScopes();
    }

    public List<XmlSignerRole> getSignerRoles() {
        return this.signature.getSignerRole();
    }

    public List<XmlSignerRole> getClaimedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CLAIMED);
    }

    public List<XmlSignerRole> getCertifiedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CERTIFIED);
    }

    public List<XmlSignerRole> getSignedAssertions() {
        return this.getSignerRolesByCategory(EndorsementType.SIGNED);
    }

    public List<String> getSignerRoleDetails(List<XmlSignerRole> listOfSignerRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        for (XmlSignerRole xmlSignerRole : listOfSignerRoles) {
            roles.add(xmlSignerRole.getRole());
        }
        return roles;
    }

    private List<XmlSignerRole> getSignerRolesByCategory(EndorsementType category) {
        ArrayList<XmlSignerRole> roles = new ArrayList<XmlSignerRole>();
        for (XmlSignerRole xmlSignerRole : this.getSignerRoles()) {
            if (!category.equals((Object)xmlSignerRole.getCategory())) continue;
            roles.add(xmlSignerRole);
        }
        return roles;
    }

    public List<XmlCommitmentTypeIndication> getCommitmentTypeIndications() {
        List<XmlCommitmentTypeIndication> commitmentTypeIndications = this.signature.getCommitmentTypeIndications();
        if (commitmentTypeIndications != null) {
            return commitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    public boolean isPolicyPresent() {
        return this.signature.getPolicy() != null;
    }

    public String getPolicyProcessingError() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getProcessingError();
        }
        return "";
    }

    public String getPolicyDescription() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDescription() != null) {
            return policy.getDescription();
        }
        return "";
    }

    public List<String> getPolicyDocumentationReferences() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDocumentationReferences() != null) {
            return policy.getDocumentationReferences();
        }
        return Collections.emptyList();
    }

    public List<String> getPolicyTransforms() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getTransformations() != null) {
            return policy.getTransformations();
        }
        return Collections.emptyList();
    }

    public String getPolicyUrl() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUrl();
        }
        return "";
    }

    public XmlUserNotice getPolicyUserNotice() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUserNotice();
        }
        return null;
    }

    public XmlSPDocSpecification getPolicyDocSpecification() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getDocSpecification();
        }
        return null;
    }

    public boolean isPolicyAsn1Processable() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isAsn1Processable() != null && policy.isAsn1Processable() != false;
        }
        return false;
    }

    public boolean isPolicyIdentified() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isIdentified() != null && policy.isIdentified() != false;
        }
        return false;
    }

    public boolean isPolicyDigestValid() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isMatch() != null && policy.getDigestAlgoAndValue().isMatch() != false;
        }
        return false;
    }

    public boolean isPolicyDigestAlgorithmsEqual() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isDigestAlgorithmsEqual() != null && policy.getDigestAlgoAndValue().isDigestAlgorithmsEqual() != false;
        }
        return false;
    }

    @Override
    public PDFRevisionWrapper getPDFRevision() {
        if (this.signature.getPDFRevision() != null) {
            return new PDFRevisionWrapper(this.signature.getPDFRevision());
        }
        return null;
    }

    public List<XmlSignerInfo> getSignatureInformationStore() {
        return this.signature.getSignerInformationStore();
    }

    public Date getVRIDictionaryCreationTime() {
        return this.signature.getVRIDictionaryCreationTime();
    }

    public byte[] getSignatureValue() {
        return this.signature.getSignatureValue();
    }

    public boolean isDocHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isDocHashOnly();
        }
        return false;
    }

    public boolean isHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isHashOnly();
        }
        return false;
    }

    @Override
    public byte[] getBinaries() {
        return this.signature.getSignatureValue();
    }
}

