/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.UriBasedEnum;

public enum CryptographicSuiteAlgorithmUsage implements UriBasedEnum
{
    SIGN_DATA("http://uri.etsi.org/19322/sign_data"),
    SIGN_CERTIFICATES("http://uri.etsi.org/19322/sign_certificates"),
    SIGN_OCSP("http://uri.etsi.org/19322/sign_ocsp"),
    SIGN_TIMESTAMPS("http://uri.etsi.org/19322/sign_timestamps"),
    VALIDATE_DATA("http://uri.etsi.org/19322/sign_data/validate_data"),
    VALIDATE_CERTIFICATES("http://uri.etsi.org/19322/sign_data/validate_data/validate_certificates"),
    VALIDATE_OCSP("http://uri.etsi.org/19322/sign_data/validate_data/validate_ocsp"),
    VALIDATE_TIMESTAMPS("http://uri.etsi.org/19322/sign_data/validate_data/validate_timestamps");

    private final String uri;

    private CryptographicSuiteAlgorithmUsage(String uri) {
        this.uri = uri;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public static CryptographicSuiteAlgorithmUsage fromUri(String uri) {
        if (uri != null) {
            for (CryptographicSuiteAlgorithmUsage algorithmUsage : CryptographicSuiteAlgorithmUsage.values()) {
                if (!algorithmUsage.uri.equals(uri)) continue;
                return algorithmUsage;
            }
        }
        return null;
    }
}

