/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidDescription;
import java.util.Objects;

public enum QCStatement implements OidDescription
{
    QC_COMPLIANCE("qc-compliance", "0.4.0.1862.1.1"),
    QC_LIMIT_VALUE("qc-limit-value", "0.4.0.1862.1.2"),
    QC_RETENTION_PERIOD("qc-retention-period", "0.4.0.1862.1.3"),
    QC_SSCD("qc-sscd", "0.4.0.1862.1.4"),
    QC_PDS("qc-pds", "0.4.0.1862.1.5"),
    QC_TYPE("qc-type", "0.4.0.1862.1.6"),
    QC_CCLEGISLATION("qc-cclegislation", "0.4.0.1862.1.7");

    private final String description;
    private final String oid;

    private QCStatement(String description, String oid) {
        this.description = description;
        this.oid = oid;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static QCStatement forLabel(String description) {
        Objects.requireNonNull(description, "Description label cannot be null!");
        for (QCStatement qcStatement : QCStatement.values()) {
            if (!description.equals(qcStatement.description)) continue;
            return qcStatement;
        }
        return null;
    }

    public static QCStatement forOID(String oid) {
        Objects.requireNonNull(oid, "OID cannot be null!");
        for (QCStatement qcStatement : QCStatement.values()) {
            if (!oid.equals(qcStatement.oid)) continue;
            return qcStatement;
        }
        return null;
    }
}

