/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilder;
import java.io.InputStream;
import java.util.Objects;

public abstract class AbstractDataObjectDigestBuilder
implements DataObjectDigestBuilder {
    protected final InputStream inputStream;
    protected final DSSDocument document;
    protected final DigestAlgorithm digestAlgorithm;

    protected AbstractDataObjectDigestBuilder(byte[] binaries) {
        this(binaries, DigestAlgorithm.SHA256);
    }

    protected AbstractDataObjectDigestBuilder(InputStream inputStream) {
        this(inputStream, DigestAlgorithm.SHA256);
    }

    protected AbstractDataObjectDigestBuilder(DSSDocument document) {
        this(document, DigestAlgorithm.SHA256);
    }

    protected AbstractDataObjectDigestBuilder(byte[] binaries, DigestAlgorithm digestAlgorithm) {
        this(new InMemoryDocument(binaries), digestAlgorithm);
    }

    protected AbstractDataObjectDigestBuilder(InputStream inputStream, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(inputStream, "InputStream cannot be null!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.document = null;
        this.inputStream = inputStream;
        this.digestAlgorithm = digestAlgorithm;
    }

    protected AbstractDataObjectDigestBuilder(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(document, "Document cannot be null!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.document = document;
        this.inputStream = null;
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public Digest build() {
        byte[] hashValue;
        if (this.document != null) {
            hashValue = this.document.getDigestValue(this.digestAlgorithm);
        } else if (this.inputStream != null) {
            hashValue = DSSUtils.digest(this.digestAlgorithm, this.inputStream);
        } else {
            throw new IllegalStateException("DSSDocument or InputStream shall be defined!");
        }
        return new Digest(this.digestAlgorithm, hashValue);
    }
}

