/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordCRLSource;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordCertificateSource;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordOCSPSource;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.common.validation.identifier.EmbeddedEvidenceRecordIdentifierBuilder;
import eu.europa.esig.dss.evidencerecord.common.validation.identifier.EvidenceRecordIdentifierBuilder;
import eu.europa.esig.dss.evidencerecord.common.validation.timestamp.EvidenceRecordTimestampSource;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DefaultEvidenceRecord
implements EvidenceRecord {
    private String filename;
    private EvidenceRecordOrigin origin;
    private EvidenceRecordIncorporationType incorporationType;
    private List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    private List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence;
    private TokenCertificateSource certificateSource;
    private OfflineCRLSource crlSource;
    private OfflineOCSPSource ocspSource;
    private EvidenceRecordTimestampSource<?> timestampSource;
    protected List<ReferenceValidation> referenceValidations;
    private List<SignatureScope> evidenceRecordScopes;
    protected List<String> structureValidationMessages;
    private ManifestFile manifestFile;
    private List<TimestampedReference> timestampedReferences;
    private EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper;
    private Identifier identifier;

    protected DefaultEvidenceRecord() {
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public EvidenceRecordOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(EvidenceRecordOrigin origin) {
        this.origin = origin;
    }

    @Override
    public EvidenceRecordIncorporationType getIncorporationType() {
        return this.incorporationType;
    }

    public void setIncorporationType(EvidenceRecordIncorporationType incorporationType) {
        this.incorporationType = incorporationType;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public ManifestFile getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    @Override
    public List<TimestampedReference> getTimestampedReferences() {
        if (this.timestampedReferences == null) {
            this.timestampedReferences = new ArrayList<TimestampedReference>();
        }
        return this.timestampedReferences;
    }

    @Override
    public void setTimestampedReferences(List<TimestampedReference> timestampedReferences) {
        this.timestampedReferences = timestampedReferences;
    }

    public List<? extends ArchiveTimeStampChainObject> getArchiveTimeStampSequence() {
        if (this.archiveTimeStampSequence == null) {
            this.archiveTimeStampSequence = this.buildArchiveTimeStampSequence();
        }
        return this.archiveTimeStampSequence;
    }

    protected List<? extends ArchiveTimeStampChainObject> buildArchiveTimeStampSequence() {
        return this.buildEvidenceRecordParser().parse();
    }

    protected abstract EvidenceRecordParser buildEvidenceRecordParser();

    @Override
    public TokenCertificateSource getCertificateSource() {
        if (this.certificateSource == null) {
            this.certificateSource = new EvidenceRecordCertificateSource(this.getArchiveTimeStampSequence());
        }
        return this.certificateSource;
    }

    @Override
    public OfflineRevocationSource<CRL> getCRLSource() {
        if (this.crlSource == null) {
            this.crlSource = new EvidenceRecordCRLSource(this.getArchiveTimeStampSequence());
        }
        return this.crlSource;
    }

    @Override
    public OfflineRevocationSource<OCSP> getOCSPSource() {
        if (this.ocspSource == null) {
            this.ocspSource = new EvidenceRecordOCSPSource(this.getArchiveTimeStampSequence());
        }
        return this.ocspSource;
    }

    @Override
    public List<ReferenceValidation> getReferenceValidation() {
        if (this.referenceValidations == null) {
            this.referenceValidations = this.validate();
        }
        return this.referenceValidations;
    }

    protected List<ReferenceValidation> validate() {
        return this.buildCryptographicEvidenceRecordVerifier().getReferenceValidations();
    }

    protected abstract EvidenceRecordTimeStampSequenceVerifier buildCryptographicEvidenceRecordVerifier();

    @Override
    public List<TimestampToken> getTimestamps() {
        return this.getTimestampSource().getTimestamps();
    }

    public EvidenceRecordTimestampSource<?> getTimestampSource() {
        if (this.timestampSource == null) {
            this.timestampSource = this.buildTimestampSource();
        }
        return this.timestampSource;
    }

    protected abstract EvidenceRecordTimestampSource<?> buildTimestampSource();

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        return this.getTimestampSource().getDetachedEvidenceRecords();
    }

    @Override
    public void addExternalEvidenceRecord(EvidenceRecord evidenceRecord) {
        this.getTimestampSource().addExternalEvidenceRecord(evidenceRecord);
    }

    @Override
    public List<SignatureScope> getEvidenceRecordScopes() {
        return this.evidenceRecordScopes;
    }

    @Override
    public void setEvidenceRecordScopes(List<SignatureScope> evidenceRecordScopes) {
        this.evidenceRecordScopes = evidenceRecordScopes;
    }

    @Override
    public DigestAlgorithm getOriginalDigestAlgorithm() {
        return this.getArchiveTimeStampSequence().get(0).getDigestAlgorithm();
    }

    @Override
    public void setEmbeddedEvidenceRecordHelper(EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper) {
        this.embeddedEvidenceRecordHelper = embeddedEvidenceRecordHelper;
    }

    @Override
    public boolean isEmbedded() {
        return this.embeddedEvidenceRecordHelper != null;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        if (this.embeddedEvidenceRecordHelper != null) {
            return this.embeddedEvidenceRecordHelper.getMasterSignature();
        }
        return null;
    }

    @Override
    public EmbeddedEvidenceRecordHelper getEmbeddedEvidenceRecordHelper() {
        return this.embeddedEvidenceRecordHelper;
    }

    @Override
    public List<String> getStructureValidationResult() {
        if (Utils.isCollectionEmpty(this.structureValidationMessages)) {
            this.structureValidationMessages = this.validateStructure();
        }
        return this.structureValidationMessages;
    }

    public List<String> validateStructure() {
        return Collections.emptyList();
    }

    @Override
    public Identifier getDSSId() {
        if (this.identifier == null) {
            this.identifier = this.embeddedEvidenceRecordHelper != null ? new EmbeddedEvidenceRecordIdentifierBuilder(this.embeddedEvidenceRecordHelper).build(this) : new EvidenceRecordIdentifierBuilder().build(this);
        }
        return this.identifier;
    }

    @Override
    public String getId() {
        return this.getDSSId().asXmlId();
    }
}

