/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformation;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformationType;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceRecordOCSPSource
extends OfflineOCSPSource {
    private static final long serialVersionUID = -8846746778038286512L;
    private static final Logger LOG = LoggerFactory.getLogger(EvidenceRecordOCSPSource.class);
    private final List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence;

    public EvidenceRecordOCSPSource(List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence) {
        this.archiveTimeStampSequence = archiveTimeStampSequence;
        this.extractOCSPs();
    }

    private void extractOCSPs() {
        if (Utils.isCollectionEmpty(this.archiveTimeStampSequence)) {
            return;
        }
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : this.archiveTimeStampSequence) {
            List<? extends ArchiveTimeStampObject> archiveTimeStamps = archiveTimeStampChainObject.getArchiveTimeStamps();
            if (!Utils.isCollectionNotEmpty(archiveTimeStamps)) continue;
            for (ArchiveTimeStampObject archiveTimeStampObject : archiveTimeStamps) {
                List<CryptographicInformation> cryptographicInformationList = archiveTimeStampObject.getCryptographicInformationList();
                if (!Utils.isCollectionNotEmpty(cryptographicInformationList)) continue;
                for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
                    if (!CryptographicInformationType.OCSP.equals((Object)cryptographicInformation.getType())) continue;
                    byte[] derEncoded = cryptographicInformation.getContent();
                    try {
                        OCSPResponseBinary ocspResponseBinary = OCSPResponseBinary.build(DSSRevocationUtils.loadOCSPFromBinaries(derEncoded));
                        this.addBinary(ocspResponseBinary, RevocationOrigin.EVIDENCE_RECORD);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to parse OCSP '{}' : {}", Utils.toBase64(derEncoded), e.getMessage(), e);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("+EvidenceRecordOCSPSource");
        }
    }
}

