/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecordAnalyzer;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSElement;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSNamespace;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSPath;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecord;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.xml.utils.DOMDocument;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmlers.XMLEvidenceRecordFacade;
import eu.europa.esig.xmlers.jaxb.EvidenceRecordType;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLEvidenceRecordAnalyzer
extends DefaultEvidenceRecordAnalyzer {
    private Element evidenceRecordElement;

    public XMLEvidenceRecordAnalyzer(DSSDocument document) {
        super(document);
        this.evidenceRecordElement = this.toEvidenceRecordElement(document);
    }

    XMLEvidenceRecordAnalyzer() {
    }

    private Element toEvidenceRecordElement(DSSDocument document) {
        Element erElement;
        try {
            Node documentNode;
            if (document instanceof DOMDocument) {
                Node erNode = ((DOMDocument)document).getNode();
                if (1 == erNode.getNodeType() && XMLERSElement.EVIDENCE_RECORD.isSameTagName(erNode.getLocalName())) {
                    return (Element)erNode;
                }
                documentNode = erNode;
            } else {
                documentNode = DomUtils.buildDOM(document);
            }
            erElement = DomUtils.getElement(documentNode, XMLERSPath.EVIDENCE_RECORD_PATH);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("An XML file is expected : %s", e.getMessage()), e);
        }
        if (erElement == null) {
            throw new IllegalInputException(String.format("No Evidence Record found within the provided document with name '%s'! Please ensure the Evidence Record is present at the root level of the provided document.", document.getName()));
        }
        return erElement;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return this.isXmlContent(dssDocument) && this.canBuildEvidenceRecord(dssDocument);
    }

    private boolean isXmlContent(DSSDocument document) {
        return document instanceof DOMDocument || DomUtils.startsWithXmlPreamble(document);
    }

    private boolean canBuildEvidenceRecord(DSSDocument dssDocument) {
        boolean bl;
        block8: {
            InputStream is = dssDocument.openStream();
            try {
                EvidenceRecordType erObject = (EvidenceRecordType)XMLEvidenceRecordFacade.newFacade().unmarshall(is, false);
                boolean bl2 = bl = erObject != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException | IOException | XMLStreamException | SAXException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public Element getEvidenceRecordElement() {
        return this.evidenceRecordElement;
    }

    public Document getRootElement() {
        return this.evidenceRecordElement.getOwnerDocument();
    }

    @Override
    protected EvidenceRecord buildEvidenceRecord() {
        if (this.evidenceRecordElement != null) {
            XmlEvidenceRecord evidenceRecord = new XmlEvidenceRecord(this.evidenceRecordElement);
            evidenceRecord.setFilename(this.document.getName());
            evidenceRecord.setOrigin(this.evidenceRecordOrigin);
            evidenceRecord.setManifestFile(this.manifestFile);
            evidenceRecord.setDetachedContents(this.getEvidenceRecordDetachedContents());
            evidenceRecord.setEmbeddedEvidenceRecordHelper(this.embeddedEvidenceRecordHelper);
            return evidenceRecord;
        }
        return null;
    }

    @Override
    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return EvidenceRecordTypeEnum.XML_EVIDENCE_RECORD;
    }

    static {
        DomUtils.registerNamespace(XMLERSNamespace.XMLERS);
    }
}

