/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.parsers;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateParser
extends XmlAdapter<String, Date> {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    @Override
    public Date unmarshal(String s) throws Exception {
        if (s == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sdf.setTimeZone(UTC);
            sdf.setLenient(false);
            return sdf.parse(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("String '%s' doesn't follow the pattern '%s'", s, DATE_FORMAT));
        }
    }

    @Override
    public String marshal(Date date) throws Exception {
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sdf.setTimeZone(UTC);
            return sdf.format(date);
        }
        return null;
    }
}

