/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESProfileParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.PdfSignatureCache;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class PAdESSignatureParameters
extends CAdESSignatureParameters
implements PAdESCommonParameters {
    private static final long serialVersionUID = -1632557456487796227L;
    private String reason;
    private String contactInfo;
    private String location;
    private String signerName;
    private int signatureSize = 9472;
    private String signatureFilter = "Adobe.PPKLite";
    private String signatureSubFilter = "ETSI.CAdES.detached";
    private String appName;
    private SignatureImageParameters signatureImageParameters;
    private CertificationPermission permission;
    private char[] passwordProtection;
    private TimeZone signingTimeZone = TimeZone.getDefault();
    private boolean includeVRIDictionary;

    @Override
    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.PAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only PAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    @Override
    public String getFilter() {
        return this.signatureFilter;
    }

    public void setFilter(String signatureFilter) {
        this.signatureFilter = signatureFilter;
    }

    @Override
    public String getSubFilter() {
        return this.signatureSubFilter;
    }

    public void setSubFilter(String signatureSubFilter) {
        this.signatureSubFilter = signatureSubFilter;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public PAdESProfileParameters getContext() {
        if (this.context == null) {
            this.context = new PAdESProfileParameters();
        }
        return (PAdESProfileParameters)this.context;
    }

    @Override
    public SignatureImageParameters getImageParameters() {
        if (this.signatureImageParameters == null) {
            this.signatureImageParameters = new SignatureImageParameters();
        }
        return this.signatureImageParameters;
    }

    public void setImageParameters(SignatureImageParameters signatureImageParameters) {
        this.signatureImageParameters = signatureImageParameters;
    }

    @Override
    public int getContentSize() {
        return this.signatureSize;
    }

    public void setContentSize(int signatureSize) {
        this.signatureSize = signatureSize;
    }

    public CertificationPermission getPermission() {
        return this.permission;
    }

    public void setPermission(CertificationPermission permission) {
        this.permission = permission;
    }

    @Override
    public char[] getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(char[] passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    @Override
    public Date getSigningDate() {
        return this.bLevel().getSigningDate();
    }

    public void setSigningTimeZone(TimeZone signingTimeZone) {
        this.signingTimeZone = signingTimeZone;
    }

    public TimeZone getSigningTimeZone() {
        return this.signingTimeZone;
    }

    public boolean isIncludeVRIDictionary() {
        return this.includeVRIDictionary;
    }

    public void setIncludeVRIDictionary(boolean includeVRIDictionary) {
        this.includeVRIDictionary = includeVRIDictionary;
    }

    @Override
    public PAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.contentTimestampParameters;
    }

    @Override
    public void setContentTimestampParameters(CAdESTimestampParameters contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters instanceof PAdESTimestampParameters ? contentTimestampParameters : new PAdESTimestampParameters(contentTimestampParameters);
    }

    @Override
    public PAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.signatureTimestampParameters;
    }

    @Override
    public void setSignatureTimestampParameters(CAdESTimestampParameters signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters instanceof PAdESTimestampParameters ? signatureTimestampParameters : new PAdESTimestampParameters(signatureTimestampParameters);
    }

    @Override
    public PAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.archiveTimestampParameters;
    }

    @Override
    public void setArchiveTimestampParameters(CAdESTimestampParameters archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters instanceof PAdESTimestampParameters ? archiveTimestampParameters : new PAdESTimestampParameters(archiveTimestampParameters);
    }

    @Override
    public PdfSignatureCache getPdfSignatureCache() {
        return this.getContext().getPdfToBeSignedCache();
    }

    @Override
    public String toString() {
        return "PAdESSignatureParameters [reason='" + this.reason + '\'' + ", contactInfo='" + this.contactInfo + '\'' + ", location='" + this.location + '\'' + ", signerName='" + this.signerName + '\'' + ", signatureSize=" + this.signatureSize + ", signatureFilter='" + this.signatureFilter + '\'' + ", signatureSubFilter='" + this.signatureSubFilter + '\'' + ", appName='" + this.appName + '\'' + ", signatureImageParameters=" + this.signatureImageParameters + ", permission=" + (Object)((Object)this.permission) + ", passwordProtection=" + Arrays.toString(this.passwordProtection) + ", signingTimeZone=" + this.signingTimeZone + ", includeVRIDictionary=" + this.includeVRIDictionary + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PAdESSignatureParameters that = (PAdESSignatureParameters)o;
        return this.signatureSize == that.signatureSize && this.includeVRIDictionary == that.includeVRIDictionary && Objects.equals(this.reason, that.reason) && Objects.equals(this.contactInfo, that.contactInfo) && Objects.equals(this.location, that.location) && Objects.equals(this.signerName, that.signerName) && Objects.equals(this.signatureFilter, that.signatureFilter) && Objects.equals(this.signatureSubFilter, that.signatureSubFilter) && Objects.equals(this.appName, that.appName) && Objects.equals(this.signatureImageParameters, that.signatureImageParameters) && this.permission == that.permission && Arrays.equals(this.passwordProtection, that.passwordProtection) && Objects.equals(this.signingTimeZone, that.signingTimeZone);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.reason);
        result = 31 * result + Objects.hashCode(this.contactInfo);
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.signerName);
        result = 31 * result + this.signatureSize;
        result = 31 * result + Objects.hashCode(this.signatureFilter);
        result = 31 * result + Objects.hashCode(this.signatureSubFilter);
        result = 31 * result + Objects.hashCode(this.appName);
        result = 31 * result + Objects.hashCode(this.signatureImageParameters);
        result = 31 * result + Objects.hashCode((Object)this.permission);
        result = 31 * result + Arrays.hashCode(this.passwordProtection);
        result = 31 * result + Objects.hashCode(this.signingTimeZone);
        result = 31 * result + Boolean.hashCode(this.includeVRIDictionary);
        return result;
    }
}

