/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignatureForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSForPAdESBaselineRequirementsChecker
extends CAdESBaselineRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CMSForPAdESBaselineRequirementsChecker.class);

    public CMSForPAdESBaselineRequirementsChecker(CAdESSignature signature) {
        super(signature);
    }

    public boolean isValidForPAdESBaselineBProfile() {
        if (((CAdESSignature)this.signature).getCMS() == null) {
            LOG.warn("DER-encoded SignedData object shall be included as the PDF signature in the entry with the key Contents of the Signature Dictionary for {}-BASELINE-B signature (General requirement (a))!", (Object)this.getBaselineSignatureForm());
            return false;
        }
        if (((CAdESSignature)this.signature).getCMS().getSignerInfos().size() != 1) {
            LOG.warn("SignedData.signerInfos shall contain one and only one signerInfo for {}-BASELINE-B signature (General requirement (a))!", (Object)this.getBaselineSignatureForm());
            return false;
        }
        if (!((CAdESSignature)this.signature).getCMS().isDetachedSignature()) {
            LOG.warn("No data shall be encapsulated in the PKCS#7 SignedData field for {}-BASELINE-B signature (General requirement (b))!", (Object)this.getBaselineSignatureForm());
            return false;
        }
        return this.cmsBaselineBRequirements();
    }

    @Override
    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.PAdES;
    }
}

