/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSigDictWrapper
implements PdfSignatureDictionary {
    private static final Logger LOG = LoggerFactory.getLogger(PdfSigDictWrapper.class);
    private PdfDict dictionary;
    private String signerName;
    private String contactInfo;
    private String reason;
    private String location;
    private Date signingDate;
    private String type;
    private String filter;
    private String subFilter;
    private byte[] contents;
    private ByteRange byteRange;
    private CertificationPermission docMDP;
    private SigFieldPermissions fieldMDP;
    private CMS cms;
    private boolean consistent;

    protected PdfSigDictWrapper() {
    }

    protected void setDictionary(PdfDict dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public String getSignerName() {
        return this.signerName;
    }

    protected void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    @Override
    public String getContactInfo() {
        return this.contactInfo;
    }

    protected void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    protected void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Date getSigningDate() {
        return this.signingDate;
    }

    protected void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    protected void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String getSubFilter() {
        return this.subFilter;
    }

    protected void setSubFilter(String subFilter) {
        this.subFilter = subFilter;
    }

    @Override
    public byte[] getContents() {
        return this.contents;
    }

    protected void setContents(byte[] contents) {
        this.contents = contents;
    }

    @Override
    public ByteRange getByteRange() {
        return this.byteRange;
    }

    protected void setByteRange(ByteRange byteRange) {
        this.byteRange = byteRange;
    }

    @Override
    public CertificationPermission getDocMDP() {
        return this.docMDP;
    }

    protected void setDocMDP(CertificationPermission docMDP) {
        this.docMDP = docMDP;
    }

    @Override
    public SigFieldPermissions getFieldMDP() {
        return this.fieldMDP;
    }

    protected void setFieldMDP(SigFieldPermissions fieldMDP) {
        this.fieldMDP = fieldMDP;
    }

    @Override
    public CMS getCMS() {
        return this.cms;
    }

    protected void setCMS(CMS cms) {
        this.cms = cms;
    }

    @Override
    public boolean checkConsistency(PdfSignatureDictionary signatureDictionary) {
        if (signatureDictionary == null) {
            LOG.warn("PdfSignatureDictionary from signed revision is null!");
            this.consistent = false;
        } else if (signatureDictionary instanceof PdfSigDictWrapper) {
            PdfSigDictWrapper dictionaryToCompare = (PdfSigDictWrapper)signatureDictionary;
            DefaultPdfObjectModificationsFinder modificationsFinder = new DefaultPdfObjectModificationsFinder();
            PdfObjectModifications pdfObjectModifications = modificationsFinder.find(dictionaryToCompare.dictionary, this.dictionary);
            List<ObjectModification> undefinedChanges = pdfObjectModifications.getUndefinedChanges();
            this.removeReferenceData(undefinedChanges);
            this.consistent = Utils.isCollectionEmpty(undefinedChanges);
            if (!this.consistent) {
                LOG.warn("The signature dictionary from final PDF revision is not equal to the signed revision version!");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Undefined modifications are : {}", (Object)undefinedChanges.stream().map(ObjectModification::getObjectTree).collect(Collectors.toList()));
                }
            }
        } else {
            LOG.warn("Provided PdfSignatureDictionary shall be instance of PdfSigDictWrapper!");
            this.consistent = false;
        }
        return this.consistent;
    }

    private void removeReferenceData(List<ObjectModification> modifications) {
        if (Utils.isCollectionNotEmpty(modifications)) {
            modifications.removeIf(objectModification -> objectModification.getObjectTree().getKeyChain().contains("Reference") && objectModification.getObjectTree().getKeyChain().contains("Data"));
        }
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }
}

