/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public final class PdfBoxUtils {
    private PdfBoxUtils() {
    }

    public static DSSDocument generateSubtractionImage(BufferedImage screenshotDoc1, BufferedImage screenshotDoc2) {
        return PdfBoxUtils.generateSubtractionImage(screenshotDoc1, screenshotDoc2, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateSubtractionImage(BufferedImage screenshotDoc1, BufferedImage screenshotDoc2, DSSResourcesHandler dssResourcesHandler) {
        int width = Math.max(screenshotDoc1.getWidth(), screenshotDoc2.getWidth());
        int height = Math.max(screenshotDoc1.getHeight(), screenshotDoc2.getHeight());
        BufferedImage outputImage = PdfBoxUtils.getOutputImage(width, height);
        ImageUtils.drawSubtractionImage(screenshotDoc1, screenshotDoc2, outputImage);
        return ImageUtils.toDSSDocument(outputImage, dssResourcesHandler);
    }

    private static BufferedImage getOutputImage(int width, int height) {
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics2D drawer = outputImage.createGraphics();
        drawer.setBackground(Color.WHITE);
        drawer.clearRect(0, 0, width, height);
        return outputImage;
    }

    public static PDAppearanceDictionary createSignatureAppearanceDictionary(PDDocument pdDocument, PDRectangle pdRectangle) {
        Objects.requireNonNull(pdDocument, "PDDocument cannot be null!");
        Objects.requireNonNull(pdRectangle, "PDRectangle cannot be null!");
        PDStream stream = new PDStream(pdDocument);
        PDFormXObject form = new PDFormXObject(stream);
        PDResources res = new PDResources();
        form.setResources(res);
        form.setFormType(1);
        form.setBBox(new PDRectangle(pdRectangle.getWidth(), pdRectangle.getHeight()));
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        return appearance;
    }

    public static MemoryUsageSetting getMemoryUsageSetting(PdfMemoryUsageSetting pdfMemoryUsageSetting) {
        switch (pdfMemoryUsageSetting.getMode()) {
            case MEMORY_FULL: {
                return MemoryUsageSetting.setupMainMemoryOnly();
            }
            case MEMORY_BUFFERED: {
                return MemoryUsageSetting.setupMainMemoryOnly(pdfMemoryUsageSetting.getMaxMemoryBytes());
            }
            case FILE: {
                return MemoryUsageSetting.setupTempFileOnly(pdfMemoryUsageSetting.getMaxStorageBytes());
            }
            case MIXED: {
                return MemoryUsageSetting.setupMixed(pdfMemoryUsageSetting.getMaxMemoryBytes(), pdfMemoryUsageSetting.getMaxStorageBytes());
            }
        }
        throw new UnsupportedOperationException(String.format("The MemoryUsageSetting mode '%s' is not supported!", new Object[]{pdfMemoryUsageSetting.getMode()}));
    }
}

