/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.xml;

import eu.europa.esig.dss.enumerations.CryptographicSuiteAlgorithmUsage;
import eu.europa.esig.dss.enumerations.CryptographicSuiteRecommendation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteAlgorithm;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteCatalogue;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteMetadata;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteParameter;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.AlgorithmIdentifierType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.AlgorithmType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.EvaluationType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.ParameterType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.PolicyNameType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.PublisherType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.SecuritySuitabilityPolicyType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.ValidityType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.algocat.ExtensionType;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicSuiteXmlCatalogue
extends CryptographicSuiteCatalogue {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicSuiteXmlCatalogue.class);
    private final SecuritySuitabilityPolicyType securitySuitabilityPolicy;

    public CryptographicSuiteXmlCatalogue(SecuritySuitabilityPolicyType securitySuitabilityPolicy) {
        Objects.requireNonNull(securitySuitabilityPolicy, "securitySuitabilityPolicy cannot be null!");
        this.securitySuitabilityPolicy = securitySuitabilityPolicy;
    }

    @Override
    protected CryptographicSuiteMetadata buildMetadata() {
        PublisherType publisher;
        CryptographicSuiteMetadata metadata = new CryptographicSuiteMetadata();
        PolicyNameType policyName = this.securitySuitabilityPolicy.getPolicyName();
        if (policyName != null) {
            metadata.setPolicyName(policyName.getName());
            metadata.setPolicyOID(policyName.getObjectIdentifier());
            metadata.setPolicyURI(policyName.getURI());
        }
        if ((publisher = this.securitySuitabilityPolicy.getPublisher()) != null) {
            metadata.setPublisherName(publisher.getName());
            metadata.setPublisherAddress(publisher.getAddress());
            metadata.setPublisherURI(publisher.getURI());
        }
        metadata.setPolicyIssueDate(this.toDate(this.securitySuitabilityPolicy.getPolicyIssueDate()));
        metadata.setNextUpdate(this.toDate(this.securitySuitabilityPolicy.getNextUpdate()));
        metadata.setUsage(this.securitySuitabilityPolicy.getUsage());
        metadata.setVersion(this.securitySuitabilityPolicy.getVersion());
        metadata.setLang(this.securitySuitabilityPolicy.getLang());
        metadata.setId(this.securitySuitabilityPolicy.getId());
        return metadata;
    }

    @Override
    protected List<CryptographicSuiteAlgorithm> buildAlgorithmList() {
        ArrayList<CryptographicSuiteAlgorithm> algorithmList = new ArrayList<CryptographicSuiteAlgorithm>();
        for (AlgorithmType algorithmType : this.securitySuitabilityPolicy.getAlgorithm()) {
            CryptographicSuiteAlgorithm algorithm = this.buildAlgorithm(algorithmType);
            if (algorithm == null) continue;
            algorithmList.add(algorithm);
        }
        return algorithmList;
    }

    private CryptographicSuiteAlgorithm buildAlgorithm(AlgorithmType algorithmType) {
        try {
            CryptographicSuiteAlgorithm algorithm = new CryptographicSuiteAlgorithm();
            AlgorithmIdentifierType algorithmIdentifier = algorithmType.getAlgorithmIdentifier();
            algorithm.setAlgorithmIdentifierName(algorithmIdentifier.getName());
            algorithm.setAlgorithmIdentifierOIDs(algorithmIdentifier.getObjectIdentifier());
            algorithm.setAlgorithmIdentifierURIs(algorithmIdentifier.getURI());
            algorithm.setEvaluationList(this.buildEvaluationList(algorithmType.getEvaluation()));
            algorithm.setInformationTextList(this.getInformationText(algorithmType));
            return algorithm;
        }
        catch (Exception e) {
            String errorMessage = "An error occurred during processing of an algorithm XML entry : {}. The entry is skipped.";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
            return null;
        }
    }

    private List<CryptographicSuiteEvaluation> buildEvaluationList(List<EvaluationType> evaluations) {
        ArrayList<CryptographicSuiteEvaluation> evaluationList = new ArrayList<CryptographicSuiteEvaluation>();
        for (EvaluationType evaluationType : evaluations) {
            evaluationList.add(this.buildEvaluation(evaluationType));
        }
        return evaluationList;
    }

    private List<String> getInformationText(AlgorithmType algorithmType) {
        if (algorithmType.getInformation() == null) {
            return Collections.emptyList();
        }
        return algorithmType.getInformation().getText();
    }

    private CryptographicSuiteEvaluation buildEvaluation(EvaluationType evaluationType) {
        CryptographicSuiteEvaluation evaluation = new CryptographicSuiteEvaluation();
        evaluation.setParameterList(this.buildParameterList(evaluationType.getParameter()));
        ValidityType validity = evaluationType.getValidity();
        if (validity != null) {
            evaluation.setValidityStart(this.toDate(validity.getStart()));
            evaluation.setValidityEnd(this.toDate(validity.getEnd()));
        }
        ExtensionType extensionType = this.getExtensionType(evaluationType.getAny());
        evaluation.setAlgorithmUsage(this.getAlgorithmUsageList(extensionType));
        evaluation.setRecommendation(this.getRecommendation(extensionType));
        return evaluation;
    }

    private ExtensionType getExtensionType(Object anyObject) {
        return this.toTargetType(anyObject, ExtensionType.class, "MoreDetails");
    }

    private <T> T toTargetType(Object object, Class<T> targetClass, String elementName) {
        if (object instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)object;
            Object value = jaxbElement.getValue();
            if (jaxbElement.getName().getLocalPart().equals(elementName) && targetClass.isInstance(value)) {
                return value;
            }
        }
        return null;
    }

    private List<CryptographicSuiteAlgorithmUsage> getAlgorithmUsageList(ExtensionType extensionType) {
        if (extensionType == null) {
            return Collections.emptyList();
        }
        ArrayList<CryptographicSuiteAlgorithmUsage> algorithmUsageList = new ArrayList<CryptographicSuiteAlgorithmUsage>();
        for (Object object : extensionType.getContent()) {
            String algorithmUsageUri = this.toTargetType(object, String.class, "AlgorithmUsage");
            CryptographicSuiteAlgorithmUsage algorithmUsage = CryptographicSuiteAlgorithmUsage.fromUri(algorithmUsageUri);
            if (algorithmUsage == null) continue;
            algorithmUsageList.add(algorithmUsage);
        }
        return algorithmUsageList;
    }

    private CryptographicSuiteRecommendation getRecommendation(ExtensionType extensionType) {
        if (extensionType == null) {
            return null;
        }
        for (Object object : extensionType.getContent()) {
            String recommendationValue = this.toTargetType(object, String.class, "Recommendation");
            CryptographicSuiteRecommendation recommendation = CryptographicSuiteRecommendation.fromValue(recommendationValue);
            if (recommendation == null) continue;
            return recommendation;
        }
        return null;
    }

    private Date toDate(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return xmlGregorianCalendar.toGregorianCalendar().getTime();
    }

    private List<CryptographicSuiteParameter> buildParameterList(List<ParameterType> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CryptographicSuiteParameter> parameterList = new ArrayList<CryptographicSuiteParameter>();
        for (ParameterType parameterType : parameters) {
            parameterList.add(this.buildParameter(parameterType));
        }
        return parameterList;
    }

    private CryptographicSuiteParameter buildParameter(ParameterType parameterType) {
        CryptographicSuiteParameter parameter = new CryptographicSuiteParameter();
        parameter.setName(parameterType.getName());
        parameter.setMin(parameterType.getMin());
        parameter.setMax(parameterType.getMax());
        return parameter;
    }
}

