/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.security.DSSCertificateTokenSecurityFactory;
import eu.europa.esig.dss.spi.security.DSSP7CCertificatesSecurityFactory;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.io.DigestOutputStream;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSUtils.class);
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final String RFC3339_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final TimeZone UTC_TIMEZONE;
    public static final String UTF8_ENCODING = "UTF-8";
    private static final byte[] LINE_BREAK_CHARS;
    private static final String OID_NAMESPACE_PREFIX = "urn:oid:";
    private static final Pattern RFC3986_URI_PATTERN;

    private DSSUtils() {
    }

    public static String formatDateToRFC(Date date) {
        return DSSUtils.formatDateWithCustomFormat(date, RFC3339_TIME_FORMAT);
    }

    public static Date parseRFCDate(String str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(RFC3339_TIME_FORMAT);
            sdf.setTimeZone(UTC_TIMEZONE);
            sdf.setLenient(false);
            return sdf.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("String '%s' doesn't follow the pattern '%s'", str, RFC3339_TIME_FORMAT));
        }
    }

    public static String formatDateWithCustomFormat(Date date, String format) {
        return DSSUtils.formatDateWithCustomFormat(date, format, UTC_TIMEZONE);
    }

    public static String formatDateWithCustomFormat(Date date, String format, String timeZone) {
        return DSSUtils.formatDateWithCustomFormat(date, format, Utils.isStringNotEmpty(timeZone) ? TimeZone.getTimeZone(timeZone) : null);
    }

    public static String formatDateWithCustomFormat(Date date, String format, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return date == null ? "N/A" : simpleDateFormat.format(date);
    }

    public static String toHex(byte[] value) {
        return value != null ? Utils.toHex(value) : null;
    }

    public static String convertToPEM(CertificateToken cert) {
        return DSSUtils.convertToPEM(cert.getCertificate());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String convertToPEM(Object obj) {
        try (StringWriter out = new StringWriter();){
            String string;
            try (PemWriter pemWriter = new PemWriter(out);){
                pemWriter.writeObject(new JcaMiscPEMGenerator(obj));
                pemWriter.flush();
                string = out.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new DSSException("Unable to convert DER to PEM", e);
        }
    }

    public static boolean isStartWithASN1SequenceTag(InputStream is) {
        byte firstByte = DSSUtils.readFirstByte(new InMemoryDocument(is));
        return DSSASN1Utils.isASN1SequenceTag(firstByte);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertToDER(String pemContent) {
        try (StringReader reader = new StringReader(pemContent);){
            byte[] byArray;
            try (PemReader pemReader = new PemReader(reader);){
                PemObject readPemObject = pemReader.readPemObject();
                byArray = readPemObject.getContent();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException("Unable to convert PEM to DER", e);
        }
    }

    public static CertificateToken loadCertificate(File file) {
        Objects.requireNonNull(file, "Input file cannot be null");
        return (CertificateToken)DSSCertificateTokenSecurityFactory.FILE_INSTANCE.build(file);
    }

    public static CertificateToken loadCertificate(byte[] input) {
        Objects.requireNonNull(input, "Input binary cannot be null");
        return (CertificateToken)DSSCertificateTokenSecurityFactory.BINARY_INSTANCE.build(input);
    }

    public static CertificateToken loadCertificate(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        return (CertificateToken)DSSCertificateTokenSecurityFactory.INPUT_STREAM_INSTANCE.build(inputStream);
    }

    public static List<CertificateToken> loadCertificateFromP7c(File file) {
        Objects.requireNonNull(file, "Input file cannot be null");
        return (List)DSSP7CCertificatesSecurityFactory.FILE_INSTANCE.build(file);
    }

    public static List<CertificateToken> loadCertificateFromP7c(byte[] input) {
        Objects.requireNonNull(input, "Input binary cannot be null");
        return (List)DSSP7CCertificatesSecurityFactory.BINARY_INSTANCE.build(input);
    }

    public static List<CertificateToken> loadCertificateFromP7c(InputStream inputStream) {
        return (List)DSSP7CCertificatesSecurityFactory.INPUT_STREAM_INSTANCE.build(inputStream);
    }

    public static CertificateToken loadCertificateFromBase64EncodedString(String base64Encoded) {
        byte[] bytes = Utils.fromBase64(base64Encoded);
        return DSSUtils.loadCertificate(bytes);
    }

    public static String getSHA1Digest(String stringToDigest) {
        return Utils.toHex(DSSUtils.digest(DigestAlgorithm.SHA1, stringToDigest.getBytes(StandardCharsets.UTF_8)));
    }

    public static boolean isSHA1Digest(String str) {
        return Utils.isStringNotBlank(str) && Utils.isHexEncoded(str) && str.length() == 40;
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, byte[] data) {
        Objects.requireNonNull(data, "The data cannot be null");
        switch (digestAlgorithm) {
            case SHAKE128: {
                return DSSUtils.computeDigest(new SHAKEDigest(128), data);
            }
            case SHAKE256: {
                return DSSUtils.computeDigest(new SHAKEDigest(256), data);
            }
        }
        MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgorithm);
        return messageDigest.digest(data);
    }

    private static byte[] computeDigest(Digest digest, byte[] data) {
        byte[] byArray;
        DigestOutputStream dos = new DigestOutputStream(digest);
        try {
            dos.write(data);
            byArray = dos.getDigest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to compute digest : %s", e.getMessage()), e);
            }
        }
        dos.close();
        return byArray;
    }

    public static MessageDigest getMessageDigest(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "The DigestAlgorithm cannot be null");
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException(String.format("Unable to create a MessageDigest for algorithm '%s'", digestAlgorithm), e);
        }
    }

    public static DigestDocument toDigestDocument(eu.europa.esig.dss.model.Digest digest) {
        return DSSUtils.toDigestDocument(digest.getAlgorithm(), digest.getValue());
    }

    public static DigestDocument toDigestDocument(DigestAlgorithm digestAlgorithm, byte[] digestValue) {
        return new DigestDocument(digestAlgorithm, Utils.toBase64(digestValue));
    }

    public static byte[] digest(DigestAlgorithm digestAlgo, InputStream inputStream) {
        try {
            MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgo);
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((count = inputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, count);
            }
            return messageDigest.digest();
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute digest : %s", e.getMessage()), e);
        }
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, DSSDocument document) {
        return document.getDigestValue(digestAlgorithm);
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, byte[] ... data) {
        MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgorithm);
        for (byte[] bytes : data) {
            messageDigest.update(bytes);
        }
        return messageDigest.digest();
    }

    public static byte[] toByteArray(File file) {
        byte[] byArray;
        block8: {
            Objects.requireNonNull(file, "The file cannot be null");
            InputStream is = DSSUtils.openInputStream(file);
            try {
                byArray = DSSUtils.toByteArray(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DSSException(String.format("Unable to read content of file '%s'. Reason : %s", file, e.getMessage()), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    private static InputStream openInputStream(File file) throws IOException {
        Objects.requireNonNull(file, "The file cannot be null");
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    public static byte[] toByteArray(DSSDocument document) {
        byte[] byArray;
        block8: {
            InputStream is = document.openStream();
            try {
                byArray = DSSUtils.toByteArray(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Unable to read content of document with name '%s'. Reason : %s", document.getName(), e.getMessage()), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream cannot be null");
        try {
            return Utils.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to read InputStream : %s", e.getMessage()), e);
        }
    }

    public static CMSSignedData toCMSSignedData(InputStream inputStream) {
        CMSSignedData cMSSignedData;
        block8: {
            InputStream is = inputStream;
            try {
                cMSSignedData = new CMSSignedData(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CMSException e) {
                    throw new DSSException("Not a valid CAdES file", e);
                }
            }
            is.close();
        }
        return cMSSignedData;
    }

    public static CMSSignedData toCMSSignedData(DSSDocument document) {
        return DSSUtils.toCMSSignedData(document.openStream());
    }

    public static CMSSignedData toCMSSignedData(byte[] encoded) {
        try {
            return new CMSSignedData(encoded);
        }
        catch (CMSException e) {
            throw new DSSException("Not a valid CMS", e);
        }
    }

    public static boolean isEmpty(DSSDocument document) {
        boolean bl;
        block9: {
            if (document instanceof DigestDocument) {
                return true;
            }
            InputStream is = document.openStream();
            try {
                boolean bl2 = bl = is.read() == -1;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Unable to check if document has a content: %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean isTimestampToken(DSSDocument document) {
        boolean bl;
        block8: {
            InputStream is = document.openStream();
            try {
                CMSSignedDataParser cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), is);
                bl = PKCSObjectIdentifiers.id_ct_TSTInfo.getId().equals(cmsSignedDataParser.getSignedContentTypeOID());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static long getFileByteSize(DSSDocument dssDocument) {
        long l;
        block8: {
            InputStream is = dssDocument.openStream();
            try {
                l = Utils.getInputStreamSize(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Cannot read the document with name [%s]", dssDocument.getName()), e);
                }
            }
            is.close();
        }
        return l;
    }

    public static void saveToFile(byte[] bytes, File file) {
        file.getParentFile().mkdirs();
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
             OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            Utils.copy(is, os);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to save a file : %s", e.getMessage()), e);
        }
    }

    public static String getNormalizedString(String str) {
        if (str == null) {
            return null;
        }
        String normalizedStr = DSSUtils.decodeURI(str);
        normalizedStr = normalizedStr.replaceAll("\\W", "_");
        return normalizedStr;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getDeterministicId(Date signingTime, TokenIdentifier id) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (signingTime != null) {
                    dos.writeLong(signingTime.getTime());
                }
                if (id != null) {
                    dos.writeChars(id.asXmlId());
                }
                dos.flush();
                string = "id-" + DSSUtils.getMD5Digest(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute a deterministic Id : %s", e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getCounterSignatureDeterministicId(Date signingTime, TokenIdentifier id, String masterSignatureId) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (signingTime != null) {
                    dos.writeLong(signingTime.getTime());
                }
                if (id != null) {
                    dos.writeChars(id.asXmlId());
                }
                if (masterSignatureId != null) {
                    dos.writeChars(masterSignatureId);
                }
                dos.flush();
                string = "id-" + DSSUtils.getMD5Digest(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute a deterministic Id for a counter-signature : %s", e.getMessage()), e);
        }
    }

    public static String getMD5Digest(byte[] bytes) {
        return Utils.toHex(DSSUtils.digest(DigestAlgorithm.MD5, bytes));
    }

    @Deprecated
    public static X500Principal getX500PrincipalOrNull(String x500PrincipalString) {
        return DSSASN1Utils.getX500PrincipalOrNull(x500PrincipalString);
    }

    public static Date getUtcDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(year, month, day, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static void printSecurityProviders() {
        Provider[] providers;
        for (Provider provider : providers = Security.getProviders()) {
            LOG.info("PROVIDER: {}", (Object)provider.getName());
            Set<Provider.Service> services = provider.getServices();
            for (Provider.Service service : services) {
                LOG.info("\tALGORITHM: {} / {} / {}", service.getAlgorithm(), service.getType(), service.getClassName());
            }
        }
    }

    public static byte readFirstByte(DSSDocument dssDocument) {
        byte[] result = new byte[1];
        try (InputStream inputStream = dssDocument.openStream();){
            inputStream.read(result, 0, 1);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot read first byte of the document. Reason : %s", e.getMessage()), e);
        }
        return result[0];
    }

    public static String decodeURI(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            uri = uri.replace("+", "%2B");
            return URLDecoder.decode(uri, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            LOG.warn("Unable to decode '{}' : {}", uri, e.getMessage(), e);
            return uri;
        }
    }

    public static String encodeURI(String fileURI) {
        if (fileURI == null) {
            return null;
        }
        Matcher matcher = RFC3986_URI_PATTERN.matcher(fileURI);
        if (!matcher.matches()) {
            LOG.warn("URI does not match RFC 3986 pattern: {}. Original URI is returned.", (Object)fileURI);
            return fileURI;
        }
        String scheme = matcher.group(2);
        String authority = matcher.group(4);
        String path = matcher.group(5);
        String query = matcher.group(7);
        String fragment = matcher.group(9);
        try {
            URI safeUri = new URI(scheme, authority, path, query, fragment);
            return safeUri.toString();
        }
        catch (URISyntaxException e) {
            String errorMessage = "URI does not match RFC 3986 pattern: {}. Reason {}. Original URI is returned.";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, fileURI, e.getMessage(), e);
            } else {
                LOG.warn(errorMessage, (Object)fileURI, (Object)e.getMessage());
            }
            return fileURI;
        }
    }

    public static String getExceptionMessage(Exception e) {
        if (e == null) {
            throw new DSSException("Cannot retrieve a message. The exception is null!");
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            return e.getCause().getMessage();
        }
        return e.getClass().getName();
    }

    public static eu.europa.esig.dss.model.Digest getDigest(DigestAlgorithm digestAlgo, DSSDocument dssDocument) {
        return new eu.europa.esig.dss.model.Digest(digestAlgo, DSSUtils.digest(digestAlgo, dssDocument));
    }

    public static String removeControlCharacters(String str) {
        if (str != null) {
            String cleanedString = str.replaceAll("[^\\P{Cntrl}]+", "");
            if (!str.equals(cleanedString)) {
                LOG.warn("The string [{}] contains illegal characters and was replaced to [{}]", (Object)str, (Object)cleanedString);
            }
            return cleanedString;
        }
        return null;
    }

    public static String replaceAllNonAlphanumericCharacters(String str, String replacement) {
        if (str != null) {
            return str.replaceAll("[^\\p{L}\\p{Nd}]+", replacement);
        }
        return null;
    }

    public static String replaceInvalidXmlCharacters(String str, String replacement) {
        if (str != null) {
            return str.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]", replacement);
        }
        return null;
    }

    public static boolean isUrnOid(String id) {
        return id != null && id.matches("^(?i)urn:oid:.*$");
    }

    public static boolean isOidCode(String oid) {
        return oid != null && oid.matches("^([0-2])((\\.0)|(\\.[1-9][0-9]*))*$");
    }

    public static String getOidCode(String urnOid) {
        if (urnOid == null) {
            return null;
        }
        return urnOid.substring(urnOid.lastIndexOf(58) + 1);
    }

    public static String toUrnOid(String oid) {
        return OID_NAMESPACE_PREFIX + oid;
    }

    public static String getObjectIdentifierValue(String oidOrUriString) {
        return DSSUtils.getObjectIdentifierValue(oidOrUriString, null, false);
    }

    public static String getObjectIdentifierValue(String oidOrUriString, ObjectIdentifierQualifier qualifier) {
        return DSSUtils.getObjectIdentifierValue(oidOrUriString, qualifier, true);
    }

    private static String getObjectIdentifierValue(String oidOrUriString, ObjectIdentifierQualifier qualifier, boolean xades) {
        String value = oidOrUriString;
        if (Utils.isStringNotEmpty(oidOrUriString)) {
            if (DSSUtils.isUrnOid(value = DSSUtils.trimWhitespacesAndNewlines(value))) {
                if (xades && !ObjectIdentifierQualifier.OID_AS_URN.equals((Object)qualifier)) {
                    LOG.debug("When OID is encoded as URN, a Qualifier=\"OIDAsURN\" shall be used!");
                }
                value = DSSUtils.getOidCode(value);
            } else if (DSSUtils.isOidCode(value)) {
                if (xades && ObjectIdentifierQualifier.OID_AS_URN.equals((Object)qualifier)) {
                    LOG.debug("When OID is encoded as URI, a Qualifier=\"OIDAsURN\" shall not be used!");
                }
            } else if (xades && qualifier != null) {
                LOG.debug("When URI is used, a Qualifier attribute shall not be present!");
            }
        }
        return value;
    }

    public static String trimWhitespacesAndNewlines(String str) {
        if (str != null) {
            str = str.replace("\n", "");
            str = str.replace("\r", "");
            str = Utils.trim(str);
        }
        return str;
    }

    public static String stripFirstLeadingOccurrence(String text, String leading) {
        if (text == null) {
            return null;
        }
        if (leading == null) {
            return text;
        }
        return text.replaceFirst("^" + leading, "");
    }

    public static List<String> getDocumentNames(List<DSSDocument> dssDocuments) {
        if (Utils.isCollectionNotEmpty(dssDocuments)) {
            return dssDocuments.stream().map(DSSDocument::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static DSSDocument getDocumentWithName(List<DSSDocument> documents, String fileName) {
        for (DSSDocument document : documents) {
            if (!fileName.equals(document.getName())) continue;
            return document;
        }
        return null;
    }

    public static DSSDocument getDocumentWithLastName(List<DSSDocument> documents) {
        if (Utils.isCollectionNotEmpty(documents)) {
            List<String> documentNames = DSSUtils.getDocumentNames(documents);
            Collections.sort(documentNames);
            return DSSUtils.getDocumentWithName(documents, documentNames.get(documentNames.size() - 1));
        }
        return null;
    }

    public static <T> void enrichCollection(Collection<T> currentCollection, Collection<T> toAddCollection) {
        for (T object : toAddCollection) {
            if (currentCollection.contains(object)) continue;
            currentCollection.add(object);
        }
    }

    public static SignatureValue convertECSignatureValue(SignatureAlgorithm expectedAlgorithm, SignatureValue signatureValue) {
        byte[] signatureValueBinaries;
        SignatureValue newSignatureValue = new SignatureValue();
        newSignatureValue.setAlgorithm(expectedAlgorithm);
        EncryptionAlgorithm expectedEncryptionAlgorithm = expectedAlgorithm.getEncryptionAlgorithm();
        EncryptionAlgorithm signatureEncryptionAlgorithm = signatureValue.getAlgorithm().getEncryptionAlgorithm();
        if (EncryptionAlgorithm.ECDSA.equals(expectedEncryptionAlgorithm) && EncryptionAlgorithm.PLAIN_ECDSA.equals(signatureEncryptionAlgorithm)) {
            signatureValueBinaries = DSSASN1Utils.toStandardDSASignatureValue(signatureValue.getValue());
        } else if (EncryptionAlgorithm.PLAIN_ECDSA.equals(expectedEncryptionAlgorithm) && EncryptionAlgorithm.ECDSA.equals(signatureEncryptionAlgorithm)) {
            signatureValueBinaries = DSSASN1Utils.toPlainDSASignatureValue(signatureValue.getValue());
        } else {
            throw new DSSException(String.format("Not supported conversion from SignatureAlgorithm '%s' defined within SignatureValue to the target algorithm '%s'", signatureValue.getAlgorithm(), expectedAlgorithm));
        }
        newSignatureValue.setValue(signatureValueBinaries);
        return newSignatureValue;
    }

    public static SignatureAlgorithm getEdDSASignatureAlgorithm(byte[] signatureValue) {
        if (signatureValue.length == 64) {
            return SignatureAlgorithm.ED25519;
        }
        if (signatureValue.length == 114) {
            return SignatureAlgorithm.ED448;
        }
        LOG.warn("Unable to identify EdDSA Signature Algorithm!");
        return null;
    }

    public static void assertSPUserNoticeConfigurationValid(UserNotice userNotice) throws IllegalArgumentException {
        boolean noticeNumbersEmpty;
        boolean organizationEmpty = Utils.isStringEmpty(userNotice.getOrganization());
        boolean bl = noticeNumbersEmpty = userNotice.getNoticeNumbers() == null || userNotice.getNoticeNumbers().length == 0;
        if (organizationEmpty != noticeNumbersEmpty) {
            throw new IllegalArgumentException("Both Organization name and NoticeNumbers shall be defined within the UserNotice configuration!");
        }
    }

    public static List<BigInteger> toBigIntegerList(int[] integers) {
        ArrayList<BigInteger> bi = new ArrayList<BigInteger>();
        for (int i : integers) {
            bi.add(BigInteger.valueOf(i));
        }
        return bi;
    }

    public static boolean isLineBreakByte(byte b) {
        for (byte m : LINE_BREAK_CHARS) {
            if (b != m) continue;
            return true;
        }
        return false;
    }

    public static String getHost(String urlString) {
        if (Utils.isStringEmpty(urlString)) {
            return "";
        }
        int doubleslash = urlString.indexOf("//");
        doubleslash = doubleslash == -1 ? 0 : (doubleslash += 2);
        int end = urlString.indexOf(47, doubleslash);
        end = end >= 0 ? end : urlString.length();
        int port = urlString.indexOf(58, doubleslash);
        end = port > 0 && port < end ? port : end;
        return urlString.substring(doubleslash, end);
    }

    static {
        DSSSecurityProvider.initSystemProviders();
        EMPTY_BYTE_ARRAY = new byte[0];
        UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
        LINE_BREAK_CHARS = new byte[]{13, 10};
        RFC3986_URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    }
}

