/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.policy;

import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.spi.policy.NonASN1SignaturePolicyValidator;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidatorLoader;
import java.util.Iterator;
import java.util.ServiceLoader;

public class DefaultSignaturePolicyValidatorLoader
implements SignaturePolicyValidatorLoader {
    private SignaturePolicyValidator defaultSignaturePolicyValidator;
    private boolean supportHashAsInTechnicalSpecification = true;

    public static DefaultSignaturePolicyValidatorLoader defaultOnlySignaturePolicyValidatorLoader(SignaturePolicyValidator defaultSignaturePolicyValidator) {
        DefaultSignaturePolicyValidatorLoader loader = new DefaultSignaturePolicyValidatorLoader();
        loader.setDefaultSignaturePolicyValidator(defaultSignaturePolicyValidator);
        loader.setSupportHashAsInTechnicalSpecification(false);
        return loader;
    }

    public static DefaultSignaturePolicyValidatorLoader defaultUnlessSpecifiedSignaturePolicyValidatorLoader(SignaturePolicyValidator defaultSignaturePolicyValidator) {
        DefaultSignaturePolicyValidatorLoader loader = new DefaultSignaturePolicyValidatorLoader();
        loader.setDefaultSignaturePolicyValidator(defaultSignaturePolicyValidator);
        loader.setSupportHashAsInTechnicalSpecification(true);
        return loader;
    }

    public static DefaultSignaturePolicyValidatorLoader policyBasedSignaturePolicyValidatorLoader() {
        return new DefaultSignaturePolicyValidatorLoader();
    }

    public void setDefaultSignaturePolicyValidator(SignaturePolicyValidator defaultSignaturePolicyValidator) {
        this.defaultSignaturePolicyValidator = defaultSignaturePolicyValidator;
    }

    public void setSupportHashAsInTechnicalSpecification(boolean supportHashAsInTechnicalSpecification) {
        this.supportHashAsInTechnicalSpecification = supportHashAsInTechnicalSpecification;
    }

    @Override
    public SignaturePolicyValidator loadValidator(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidator validator = null;
        if (!(this.defaultSignaturePolicyValidator == null || this.supportHashAsInTechnicalSpecification && signaturePolicy.isHashAsInTechnicalSpecification())) {
            validator = this.defaultSignaturePolicyValidator;
        } else {
            ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
            Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
            if (validatorOptions.hasNext()) {
                for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                    if (!signaturePolicyValidator.canValidate(signaturePolicy)) continue;
                    validator = signaturePolicyValidator;
                    break;
                }
            }
            if (validator == null) {
                validator = new NonASN1SignaturePolicyValidator();
            }
        }
        return validator;
    }
}

