/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.security;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.security.DSSSecurityFactory;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class DSSP7CCertificatesSecurityFactory<I>
extends DSSSecurityFactory<I, List<CertificateToken>> {
    public static final DSSP7CCertificatesSecurityFactory<InputStream> INPUT_STREAM_INSTANCE = new DSSP7CCertificatesSecurityFactory<InputStream>(){

        @Override
        protected String toString(InputStream input) {
            return "InputStream";
        }

        @Override
        public List<CertificateToken> build(InputStream input) {
            List certificateTokens = (List)this.buildWithPrimarySecurityProvider(input);
            if (certificateTokens != null && certificateTokens.size() != 0) {
                return certificateTokens;
            }
            throw new DSSException(String.format("Unable to load %s for the given certificate chain provided as a %s. All security providers have failed. More detail in debug mode.", this.getFactoryClassName(), input.getClass().getSimpleName()));
        }

        @Override
        protected List<CertificateToken> buildWithProvider(InputStream input, Provider securityProvider) {
            ArrayList<CertificateToken> arrayList;
            block12: {
                ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
                InputStream is = input;
                try {
                    Collection<? extends Certificate> certificatesCollection = CertificateFactory.getInstance("X.509", securityProvider).generateCertificates(is);
                    if (certificatesCollection != null) {
                        for (X509Certificate x509Certificate : certificatesCollection) {
                            certificates.add(new CertificateToken(x509Certificate));
                        }
                    }
                    if (certificates.isEmpty()) {
                        throw new DSSException("No certificate found in the InputStream");
                    }
                    arrayList = certificates;
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DSSException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new DSSException(String.format("Failed to load certificate(s) : %s", e.getMessage()), e);
                    }
                }
                is.close();
            }
            return arrayList;
        }
    };
    public static final DSSP7CCertificatesSecurityFactory<byte[]> BINARY_INSTANCE = new DSSP7CCertificatesSecurityFactory<byte[]>(){

        @Override
        protected String toString(byte[] input) {
            return input != null ? Utils.toBase64(input) : null;
        }

        @Override
        protected List<CertificateToken> buildWithProvider(byte[] input, Provider securityProvider) throws Exception {
            return (List)INPUT_STREAM_INSTANCE.buildWithProvider(new ByteArrayInputStream(input), securityProvider);
        }
    };
    public static final DSSP7CCertificatesSecurityFactory<File> FILE_INSTANCE = new DSSP7CCertificatesSecurityFactory<File>(){

        @Override
        protected String toString(File input) {
            return input != null ? input.getPath() : null;
        }

        @Override
        protected List<CertificateToken> buildWithProvider(File input, Provider securityProvider) throws Exception {
            try {
                return (List)INPUT_STREAM_INSTANCE.buildWithProvider(Files.newInputStream(input.toPath(), new OpenOption[0]), securityProvider);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to find a file '%s' : %s", input.getPath(), e.getMessage()), e);
            }
        }
    };

    private DSSP7CCertificatesSecurityFactory() {
    }

    @Override
    protected String getFactoryClassName() {
        return CertificateFactory.class.getSimpleName();
    }
}

