/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationData {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationData.class);
    private final Set<CertificateToken> certificateTokens = new HashSet<CertificateToken>();
    private final Set<CRLToken> crlTokens = new HashSet<CRLToken>();
    private final Set<OCSPToken> ocspTokens = new HashSet<OCSPToken>();
    private final Set<EntityIdentifier> storedPublicKeys = new HashSet<EntityIdentifier>();

    public Set<CertificateToken> getCertificateTokens() {
        return Collections.unmodifiableSet(this.certificateTokens);
    }

    public Set<CRLToken> getCrlTokens() {
        return Collections.unmodifiableSet(this.crlTokens);
    }

    public Set<OCSPToken> getOcspTokens() {
        return Collections.unmodifiableSet(this.ocspTokens);
    }

    public boolean addToken(Token token) {
        if (token instanceof CertificateToken) {
            if (this.addCertificateToken((CertificateToken)token)) {
                return true;
            }
        } else if (token instanceof RevocationToken) {
            if (this.addRevocationToken((RevocationToken)token)) {
                return true;
            }
        } else {
            throw new DSSException(String.format("Unexpected token with Id '%s'", token.getDSSIdAsString()));
        }
        LOG.trace("ValidationData instance already contains token with Id '{}'", (Object)token.getDSSIdAsString());
        return false;
    }

    private boolean addCertificateToken(CertificateToken certificateToken) {
        boolean added;
        if (!this.containsCertificateToken(certificateToken) && (added = this.certificateTokens.add(certificateToken))) {
            this.storedPublicKeys.add(certificateToken.getEntityKey());
            LOG.trace("CertificateToken with Id '{}' has been added to the ValidationData instance", (Object)certificateToken.getDSSIdAsString());
            return true;
        }
        return false;
    }

    private boolean addRevocationToken(RevocationToken<?> revocationToken) {
        if (RevocationType.CRL.equals((Object)revocationToken.getRevocationType())) {
            boolean added;
            CRLToken crlToken = (CRLToken)revocationToken;
            if (!this.containsCRLToken(crlToken) && (added = this.crlTokens.add(crlToken))) {
                LOG.trace("CRL RevocationToken with Id '{}' has been added to the ValidationData instance", (Object)revocationToken.getDSSIdAsString());
                return true;
            }
        } else if (RevocationType.OCSP.equals((Object)revocationToken.getRevocationType())) {
            boolean added;
            OCSPToken ocspToken = (OCSPToken)revocationToken;
            if (!this.containsOCSPToken(ocspToken) && (added = this.ocspTokens.add(ocspToken))) {
                LOG.trace("OCSP RevocationToken with Id '{}' has been added to the ValidationData instance", (Object)revocationToken.getDSSIdAsString());
                return true;
            }
        } else {
            throw new DSSException(String.format("Unexpected RevocationToken with Id '%s'", revocationToken.getDSSIdAsString()));
        }
        return false;
    }

    private boolean containsCertificateToken(CertificateToken certificateTokenToAdd) {
        return this.certificateTokens.contains(certificateTokenToAdd) || this.storedPublicKeys.contains(certificateTokenToAdd.getEntityKey());
    }

    private boolean containsCRLToken(CRLToken crlTokenToAdd) {
        for (CRLToken crlToken : this.crlTokens) {
            if (!crlTokenToAdd.getDSSIdAsString().equals(crlToken.getDSSIdAsString())) continue;
            return true;
        }
        return false;
    }

    private boolean containsOCSPToken(OCSPToken ocspTokenToAdd) {
        for (OCSPToken ocspToken : this.ocspTokens) {
            if (!ocspTokenToAdd.getDSSIdAsString().equals(ocspToken.getDSSIdAsString())) continue;
            return true;
        }
        return false;
    }

    public void addValidationData(ValidationData validationData) {
        for (Token token : validationData.getCertificateTokens()) {
            this.addToken(token);
        }
        for (Token token : validationData.getCrlTokens()) {
            this.addToken(token);
        }
        for (Token token : validationData.getOcspTokens()) {
            this.addToken(token);
        }
    }

    public void excludeValidationData(ValidationData validationDataToExclude) {
        this.excludeCertificateTokens(validationDataToExclude.getCertificateTokens());
        this.excludeCRLTokensCollection(validationDataToExclude.getCrlTokens());
        this.excludeOCSPTokensCollection(validationDataToExclude.getOcspTokens());
    }

    public void excludeCertificateTokens(Collection<CertificateToken> certificateTokensToExclude) {
        if (Utils.isCollectionNotEmpty(certificateTokensToExclude)) {
            for (CertificateToken certificateToken : certificateTokensToExclude) {
                if (!this.containsCertificateToken(certificateToken)) continue;
                this.storedPublicKeys.remove(certificateToken.getEntityKey());
                this.excludeWithEntityKey(certificateToken.getEntityKey());
            }
        }
    }

    private void excludeWithEntityKey(EntityIdentifier entityIdentifier) {
        this.certificateTokens.removeIf(certToken -> entityIdentifier.equals(certToken.getEntityKey()));
    }

    public void excludeCRLTokens(Collection<? extends Identifier> crlTokensToExclude) {
        if (Utils.isCollectionNotEmpty(crlTokensToExclude)) {
            Set tokenIdsToExclude = crlTokensToExclude.stream().map(Identifier::asXmlId).collect(Collectors.toSet());
            this.crlTokens.removeIf(crlToken -> tokenIdsToExclude.contains(crlToken.getDSSIdAsString()));
        }
    }

    public void excludeCRLTokensCollection(Collection<CRLToken> crlTokensToExclude) {
        if (Utils.isCollectionNotEmpty(crlTokensToExclude)) {
            this.excludeCRLTokens(crlTokensToExclude.stream().map(Token::getDSSId).collect(Collectors.toSet()));
        }
    }

    public void excludeOCSPTokens(Collection<? extends Identifier> ocspTokensToExclude) {
        if (Utils.isCollectionNotEmpty(ocspTokensToExclude)) {
            Set tokenIdsToExclude = ocspTokensToExclude.stream().map(Identifier::asXmlId).collect(Collectors.toSet());
            this.ocspTokens.removeIf(ocspToken -> tokenIdsToExclude.contains(ocspToken.getDSSIdAsString()));
        }
    }

    public void excludeOCSPTokensCollection(Collection<OCSPToken> ocspTokensToExclude) {
        if (Utils.isCollectionNotEmpty(ocspTokensToExclude)) {
            this.excludeOCSPTokens(ocspTokensToExclude.stream().map(Token::getDSSId).collect(Collectors.toSet()));
        }
    }

    public boolean isEmpty() {
        return Utils.isCollectionEmpty(this.certificateTokens) && Utils.isCollectionEmpty(this.crlTokens) && Utils.isCollectionEmpty(this.ocspTokens);
    }
}

