/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampCRLSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractTimestampSource {
    protected AbstractTimestampSource() {
    }

    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReference(List<TimestampedReference> referenceList, Identifier identifier, TimestampedObjectType category) {
        this.addReferences(referenceList, Arrays.asList(new TimestampedReference(identifier.asXmlId(), category)));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        DSSUtils.enrichCollection(referenceList, referencesToAdd);
    }

    protected List<TimestampedReference> getReferencesFromTimestamp(TimestampToken timestampToken, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
        this.addReferences(references, timestampToken.getTimestampedReferences());
        this.addReferences(references, this.getEncapsulatedValuesFromTimestamp(timestampToken, certificateSource, crlSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedValuesFromTimestamp(TimestampToken timestampedTimestamp, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        TimestampCertificateSource timestampCertificateSource = timestampedTimestamp.getCertificateSource();
        this.addReferences(references, this.createReferencesForCertificates(timestampCertificateSource.getCertificates()));
        this.addReferences(references, this.createReferencesForCertificateRefs(timestampCertificateSource.getAllCertificateRefs(), timestampCertificateSource, certificateSource));
        TimestampCRLSource timestampCRLSource = timestampedTimestamp.getCRLSource();
        this.addReferences(references, this.createReferencesForCRLBinaries(timestampCRLSource.getAllRevocationBinaries()));
        this.addReferences(references, this.createReferencesForCRLRefs(timestampCRLSource.getAllRevocationReferences(), timestampCRLSource, crlSource));
        TimestampOCSPSource timestampOCSPSource = timestampedTimestamp.getOCSPSource();
        this.addReferences(references, this.createReferencesForOCSPBinaries(timestampOCSPSource.getAllRevocationBinaries(), certificateSource));
        this.addReferences(references, this.createReferencesForOCSPRefs(timestampOCSPSource.getAllRevocationReferences(), timestampOCSPSource, certificateSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> getReferencesFromEvidenceRecord(EvidenceRecord evidenceRecord, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, new TimestampedReference(evidenceRecord.getId(), TimestampedObjectType.EVIDENCE_RECORD));
        this.addReferences(references, evidenceRecord.getTimestampedReferences());
        this.addReferences(references, this.getEncapsulatedValuesFromEvidenceRecord(evidenceRecord, certificateSource, crlSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedValuesFromEvidenceRecord(EvidenceRecord evidenceRecord, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            this.addReferences(references, this.getReferencesFromTimestamp(timestampToken, certificateSource, crlSource, ocspSource));
        }
        TokenCertificateSource erCertificateSource = evidenceRecord.getCertificateSource();
        this.addReferences(references, this.createReferencesForCertificates(erCertificateSource.getCertificates()));
        this.addReferences(references, this.createReferencesForCertificateRefs(erCertificateSource.getAllCertificateRefs(), erCertificateSource, certificateSource));
        OfflineRevocationSource<CRL> erCRLSource = evidenceRecord.getCRLSource();
        this.addReferences(references, this.createReferencesForCRLBinaries(erCRLSource.getAllRevocationBinaries()));
        this.addReferences(references, this.createReferencesForCRLRefs(erCRLSource.getAllRevocationReferences(), erCRLSource, crlSource));
        OfflineRevocationSource<OCSP> erOCSPSource = evidenceRecord.getOCSPSource();
        this.addReferences(references, this.createReferencesForOCSPBinaries(erOCSPSource.getAllRevocationBinaries(), certificateSource));
        this.addReferences(references, this.createReferencesForOCSPRefs(erOCSPSource.getAllRevocationReferences(), erOCSPSource, certificateSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> getSignerDataTimestampedReferences(List<SignatureScope> signatureScopes) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                this.addReference(references, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
                if (!Utils.isCollectionNotEmpty(signatureScope.getChildren())) continue;
                this.addReferences(references, this.getSignerDataTimestampedReferences(signatureScope.getChildren()));
            }
        }
        return references;
    }

    protected List<TimestampedReference> createReferencesForCertificates(Collection<CertificateToken> certificates) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificates) {
            this.addReference(references, this.createReferenceForCertificate(certificateToken));
        }
        return references;
    }

    protected TimestampedReference createReferenceForCertificate(CertificateToken certificateToken) {
        return this.createReferenceForIdentifier(certificateToken.getDSSId(), TimestampedObjectType.CERTIFICATE);
    }

    protected List<TimestampedReference> createReferencesForIdentifiers(Collection<? extends Identifier> identifiers, TimestampedObjectType timestampedObjectType) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier identifier : identifiers) {
            timestampedReferences.add(this.createReferenceForIdentifier(identifier, timestampedObjectType));
        }
        return timestampedReferences;
    }

    protected TimestampedReference createReferenceForIdentifier(Identifier identifier, TimestampedObjectType timestampedObjectType) {
        return new TimestampedReference(identifier.asXmlId(), timestampedObjectType);
    }

    protected List<TimestampedReference> createReferencesForCRLBinaries(Collection<? extends EncapsulatedRevocationTokenIdentifier<CRL>> crlBinaryIdentifiers) {
        return this.createReferencesForIdentifiers(crlBinaryIdentifiers, TimestampedObjectType.REVOCATION);
    }

    protected List<TimestampedReference> createReferencesForOCSPBinaries(Collection<? extends EncapsulatedRevocationTokenIdentifier<OCSP>> ocspBinaryIdentifiers, ListCertificateSource certificateSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (EncapsulatedRevocationTokenIdentifier<OCSP> encapsulatedRevocationTokenIdentifier : ocspBinaryIdentifiers) {
            if (!(encapsulatedRevocationTokenIdentifier instanceof OCSPResponseBinary)) continue;
            OCSPResponseBinary ocspResponseBinary = (OCSPResponseBinary)encapsulatedRevocationTokenIdentifier;
            this.addReferences(references, this.createReferencesForOCSPBinary(ocspResponseBinary, certificateSource));
        }
        return references;
    }

    protected List<TimestampedReference> createReferencesForOCSPBinary(OCSPResponseBinary ocspResponseBinary, ListCertificateSource certificateSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, this.createReferenceForIdentifier(ocspResponseBinary, TimestampedObjectType.REVOCATION));
        OCSPCertificateSource ocspCertificateSource = new OCSPCertificateSource(ocspResponseBinary.getBasicOCSPResp());
        this.addReferences(references, this.createReferencesForCertificates(ocspCertificateSource.getCertificates()));
        this.addReferences(references, this.createReferencesForCertificateRefs(ocspCertificateSource.getAllCertificateRefs(), ocspCertificateSource, certificateSource));
        return references;
    }

    protected List<TimestampedReference> createReferencesForCertificateRefs(Collection<CertificateRef> certificateRefs, CertificateSource currentCertificateSource, ListCertificateSource listCertificateSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CertificateRef certRef : certificateRefs) {
            Set<CertificateToken> certificateTokens = currentCertificateSource.findTokensFromCertRef(certRef);
            if (Utils.isCollectionEmpty(certificateTokens)) {
                certificateTokens = listCertificateSource.findTokensFromCertRef(certRef);
            }
            if (Utils.isCollectionNotEmpty(certificateTokens)) {
                this.addReferences(timestampedReferences, this.createReferencesForCertificates(certificateTokens));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(certRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> createReferencesForCRLRefs(Collection<? extends RevocationRef<CRL>> crlRefs, OfflineRevocationSource<CRL> currentCRLSource, ListRevocationSource<CRL> listCRLSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<CRL> revocationRef : crlRefs) {
            EncapsulatedRevocationTokenIdentifier<CRL> token = currentCRLSource.findBinaryForReference(revocationRef);
            if (token == null) {
                token = listCRLSource.findBinaryForReference(revocationRef);
            }
            if (token != null) {
                this.addReference(timestampedReferences, new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> createReferencesForOCSPRefs(Collection<? extends RevocationRef<OCSP>> ocspRefs, OfflineRevocationSource<OCSP> currentOCSPSource, ListCertificateSource listCertificateSource, ListRevocationSource<OCSP> listOCSPSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<OCSP> revocationRef : ocspRefs) {
            EncapsulatedRevocationTokenIdentifier<OCSP> token = currentOCSPSource.findBinaryForReference(revocationRef);
            if (token == null) {
                token = listOCSPSource.findBinaryForReference(revocationRef);
            }
            if (token != null) {
                this.addReferences(timestampedReferences, this.createReferencesForOCSPBinary((OCSPResponseBinary)token, listCertificateSource));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected void processEvidenceRecordTimestamps(EvidenceRecord evidenceRecord) {
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            this.ensureOnlyDataTimestampReferencesPresent(timestampToken.getTimestampedReferences(), evidenceRecord.getTimestampedReferences());
            this.addReferences(timestampToken.getTimestampedReferences(), evidenceRecord.getTimestampedReferences());
        }
    }

    protected void processEmbeddedEvidenceRecords(EvidenceRecord evidenceRecord) {
        for (EvidenceRecord embeddedEvidenceRecord : evidenceRecord.getDetachedEvidenceRecords()) {
            this.addReferences(embeddedEvidenceRecord.getTimestampedReferences(), evidenceRecord.getTimestampedReferences());
            this.processEvidenceRecordTimestamps(embeddedEvidenceRecord);
        }
    }

    private void ensureOnlyDataTimestampReferencesPresent(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToCheck) {
        referenceList.removeIf(timestampedReference -> {
            if (!TimestampedObjectType.SIGNED_DATA.equals((Object)timestampedReference.getCategory())) return false;
            if (!referencesToCheck.stream().noneMatch(timestampedReference::equals)) return false;
            return true;
        });
    }
}

