/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIACertificateSource
extends CommonCertificateSource {
    private static final long serialVersionUID = -2604947158902474169L;
    private static final Logger LOG = LoggerFactory.getLogger(AIACertificateSource.class);
    private final CertificateToken certificate;

    protected AIACertificateSource(CertificateToken certificate) {
        Objects.requireNonNull(certificate, "The certificate cannot be null");
        this.certificate = certificate;
    }

    public static AIACertificateSource forCertificateToken(CertificateToken certificate, AIASource aiaSource) {
        LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)certificate.getAbbreviation());
        AIACertificateSource aiaCertificateSource = new AIACertificateSource(certificate);
        try {
            LinkedHashSet<CertificateToken> extractedCertificates = new LinkedHashSet<CertificateToken>(aiaSource.getCertificatesByAIA(certificate));
            if (Utils.isCollectionNotEmpty(extractedCertificates)) {
                CertificateToken currentCertificate = certificate;
                while (currentCertificate != null) {
                    CertificateToken issuer = AIACertificateSource.getIssuer(currentCertificate, extractedCertificates);
                    if (aiaCertificateSource.getCertificates().contains(issuer)) break;
                    if (issuer != null) {
                        aiaCertificateSource.addCertificate(issuer);
                    }
                    currentCertificate = issuer;
                }
                if (Utils.isCollectionEmpty(aiaCertificateSource.getCertificates())) {
                    for (CertificateToken certificateToken : extractedCertificates) {
                        aiaCertificateSource.addCertificate(certificateToken);
                    }
                }
            } else {
                LOG.warn("No AIA certificates have been retrieved for a certificate with Id '{}'", (Object)certificate.getDSSIdAsString());
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred on attempt to retrieve certificate's CA issuers : {}", (Object)e.getMessage(), (Object)e);
        }
        return aiaCertificateSource;
    }

    protected static CertificateToken getIssuer(CertificateToken certificate, Collection<CertificateToken> candidates) {
        CertificateToken issuer = new TokenIssuerSelector(certificate, candidates).getIssuer();
        return issuer != null && certificate.isSignedBy(issuer) ? issuer : null;
    }

    public CertificateToken getIssuerFromAIA() {
        List<CertificateToken> candidates = this.getCertificates();
        if (Utils.isCollectionNotEmpty(candidates)) {
            CertificateToken issuer = AIACertificateSource.getIssuer(this.certificate, candidates);
            if (issuer == null) {
                LOG.warn("The retrieved certificate(s) using AIA do not sign the certificate with Id : {}.", (Object)this.certificate.getDSSIdAsString());
            }
            return issuer;
        }
        return null;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.AIA;
    }
}

