/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlValidatedID;

public final class CRLRef
extends RevocationRef<CRL> {
    private static final long serialVersionUID = -6785644604097791548L;
    private X500Principal crlIssuer;
    private Date crlIssueTime;
    private BigInteger crlNumber;

    public CRLRef(Digest digest) {
        this.digest = digest;
    }

    public CRLRef(Digest digest, X500Principal crlIssuer, Date crlIssueTime) {
        this.digest = digest;
        this.crlIssuer = crlIssuer;
        this.crlIssueTime = crlIssueTime;
    }

    public CRLRef(Digest digest, X500Principal crlIssuer, Date crlIssueTime, BigInteger crlNumber) {
        this.digest = digest;
        this.crlIssuer = crlIssuer;
        this.crlIssueTime = crlIssueTime;
        this.crlNumber = crlNumber;
    }

    public CRLRef(CrlValidatedID cmsRef) {
        try {
            CrlIdentifier crlIdentifier = cmsRef.getCrlIdentifier();
            if (crlIdentifier != null) {
                this.crlIssuer = DSSASN1Utils.toX500Principal(crlIdentifier.getCrlIssuer());
                this.crlIssueTime = crlIdentifier.getCrlIssuedTime().getDate();
                this.crlNumber = crlIdentifier.getCrlNumber();
            }
            this.digest = DSSRevocationUtils.getDigest(cmsRef.getCrlHash());
        }
        catch (Exception e) {
            throw new DSSException("Unable to build CRLRef from CrlValidatedID", e);
        }
    }

    public X500Principal getCrlIssuer() {
        return this.crlIssuer;
    }

    @Deprecated
    public void setCrlIssuer(X500Principal crlIssuer) {
        this.crlIssuer = crlIssuer;
    }

    @Deprecated
    public Date getCrlIssuedTime() {
        return this.crlIssueTime;
    }

    public Date getCrlIssueTime() {
        return this.crlIssueTime;
    }

    @Deprecated
    public void setCrlIssuedTime(Date crlIssueTime) {
        this.crlIssueTime = crlIssueTime;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    @Deprecated
    public void setCrlNumber(BigInteger crlNumber) {
        this.crlNumber = crlNumber;
    }

    @Override
    public String toString() {
        return "CRLRef [crlIssuer=" + this.crlIssuer + ", crlIssueTime=" + this.crlIssueTime + ", crlNumber=" + this.crlNumber + "] " + super.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CRLRef crlRef = (CRLRef)object;
        return Objects.equals(this.crlIssuer, crlRef.crlIssuer) && Objects.equals(this.crlIssueTime, crlRef.crlIssueTime) && Objects.equals(this.crlNumber, crlRef.crlNumber);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.crlIssuer);
        result = 31 * result + Objects.hashCode(this.crlIssueTime);
        result = 31 * result + Objects.hashCode(this.crlNumber);
        return result;
    }
}

