/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.enumerations.SignatureProfile;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.fx.CollectionFilesToStringConverter;
import eu.europa.esig.dss.standalone.fx.DSSFileChooser;
import eu.europa.esig.dss.standalone.fx.DSSFileChooserLoader;
import eu.europa.esig.dss.standalone.fx.FileToStringConverter;
import eu.europa.esig.dss.standalone.model.ExtensionModel;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.standalone.source.TLValidationJobExecutor;
import eu.europa.esig.dss.standalone.task.ExtensionTask;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionController.class);
    @FXML
    public Button signedFileSelectButton;
    @FXML
    public Button originalFilesSelectButton;
    @FXML
    public ComboBox<SignatureProfile> comboProfile;
    @FXML
    public Label warningMockTSALabel;
    @FXML
    public Button extendButton;
    @FXML
    public HBox refreshBox;
    @FXML
    public Button refreshLOTL;
    @FXML
    public Label nbCertificates;
    @FXML
    public Label warningLabel;
    private ExtensionModel model;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.model = new ExtensionModel();
        this.signedFileSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("File to extend");
                File fileToExtend = fileChooser.showOpenDialog(ExtensionController.this.stage);
                ExtensionController.this.model.setFileToExtend(fileToExtend);
            }
        });
        this.signedFileSelectButton.textProperty().bindBidirectional(this.model.fileToExtendProperty(), new FileToStringConverter());
        this.originalFilesSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Original file(s)");
                List<File> files = fileChooser.showOpenMultipleDialog(ExtensionController.this.stage);
                ExtensionController.this.model.setOriginalDocuments(files);
            }
        });
        this.originalFilesSelectButton.textProperty().bindBidirectional(this.model.originalDocumentsProperty(), new CollectionFilesToStringConverter());
        this.comboProfile.valueProperty().bindBidirectional(this.model.signatureProfileProperty());
        this.comboProfile.setDisable(false);
        this.comboProfile.getItems().addAll((SignatureProfile[])new SignatureProfile[]{SignatureProfile.BASELINE_T, SignatureProfile.BASELINE_LT, SignatureProfile.BASELINE_LTA});
        this.comboProfile.setValue(SignatureProfile.BASELINE_T);
        final BooleanBinding disableExtendButton = this.model.fileToExtendProperty().isNull().or(this.model.signatureProfileProperty().isNull());
        this.extendButton.disableProperty().bind(disableExtendButton);
        this.extendButton.setOnAction(new EventHandler<ActionEvent>(this){
            final /* synthetic */ ExtensionController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handle(ActionEvent event) {
                final Service<DSSDocument> service = new Service<DSSDocument>(){

                    @Override
                    protected Task<DSSDocument> createTask() {
                        return new ExtensionTask(this$0.model, TLValidationJobExecutor.getInstance().getCertificateSources());
                    }
                };
                service.setOnSucceeded(new EventHandler<WorkerStateEvent>(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void handle(WorkerStateEvent event) {
                        this.this$1.this$0.save((DSSDocument)service.getValue());
                        this.this$1.this$0.extendButton.disableProperty().bind(disableExtendButton);
                    }
                });
                service.setOnFailed(new EventHandler<WorkerStateEvent>(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void handle(WorkerStateEvent event) {
                        String errorMessage = "Oops an error occurred : " + service.getMessage();
                        LOG.error(errorMessage, service.getException());
                        Alert alert = new Alert(Alert.AlertType.ERROR, errorMessage, ButtonType.CLOSE);
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.showAndWait();
                        this.this$1.this$0.extendButton.disableProperty().bind(disableExtendButton);
                    }
                });
                this.this$0.extendButton.disableProperty().bind(service.runningProperty());
                service.start();
            }
        });
        this.warningMockTSALabel.setVisible(Utils.isTrue(PropertyReader.getBooleanProperty("timestamp.mock")));
    }
}

