/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationBlock;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DetailedReportForCertificateBuilder
extends AbstractDetailedReportBuilder {
    private final String certificateId;

    public DetailedReportForCertificateBuilder(I18nProvider i18nProvider, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, String certificateId) {
        super(i18nProvider, currentTime, policy, diagnosticData);
        this.certificateId = certificateId;
    }

    public XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        this.executeValidation(detailedReport, bbbs);
        return detailedReport;
    }

    protected CertificateWrapper getCertificate() {
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("The certificate with the given Id '%s' has not been found in DiagnosticData", this.certificateId));
        }
        return certificate;
    }

    protected Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        this.process(Collections.singleton(this.getCertificate()), Context.CERTIFICATE, bbbs);
        return bbbs;
    }

    protected void executeValidation(XmlDetailedReport detailedReport, Map<String, XmlBasicBuildingBlocks> bbbs) {
        this.buildXmlCertificate(detailedReport, bbbs);
    }

    protected XmlCertificate buildXmlCertificate(XmlDetailedReport detailedReport, Map<String, XmlBasicBuildingBlocks> bbbs) {
        XmlBasicBuildingBlocks basicBuildingBlocks = bbbs.get(this.certificateId);
        XmlCertificate xmlCertificate = new XmlCertificate();
        xmlCertificate.setId(this.certificateId);
        CertificateQualificationBlock cqb = this.getCertificateQualificationBlock(detailedReport, basicBuildingBlocks);
        XmlCertificateQualificationProcess xmlCertificateQualificationProcess = (XmlCertificateQualificationProcess)cqb.execute();
        xmlCertificate.setCertificateQualificationProcess(xmlCertificateQualificationProcess);
        detailedReport.getSignatureOrTimestampOrEvidenceRecord().add(xmlCertificate);
        return xmlCertificate;
    }

    protected CertificateQualificationBlock getCertificateQualificationBlock(XmlDetailedReport detailedReport, XmlBasicBuildingBlocks basicBuildingBlocks) {
        return new CertificateQualificationBlock(this.i18nProvider, basicBuildingBlocks.getConclusion(), this.currentTime, this.getCertificate(), detailedReport.getTLAnalysis());
    }
}

