/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public abstract class AbstractValueCheckItem<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private static final String ALL_VALUE = "*";
    private final ValueRule constraint;

    protected AbstractValueCheckItem(I18nProvider i18nProvider, T result, ValueRule constraint) {
        super(i18nProvider, result, constraint);
        this.constraint = constraint;
    }

    protected boolean processValueCheck(String value) {
        if (Utils.isStringEmpty(value)) {
            return false;
        }
        String expected = this.constraint.getValue();
        if (ALL_VALUE.equals(expected)) {
            return true;
        }
        return Utils.areStringsEqual(expected, value);
    }
}

