/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChainCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;
import java.util.List;

public abstract class AlgorithmObsolescenceValidation<T>
extends Chain<XmlAOV> {
    protected final T token;
    protected final Context context;
    protected final Date validationDate;
    protected final ValidationPolicy validationPolicy;
    protected MessageTag position;
    protected CryptographicSuite cryptographicSuite;
    protected XmlCryptographicValidation signatureCryptographicValidation;
    protected XmlCryptographicValidation signedAttributesCryptographicValidation;
    protected XmlCryptographicValidation digestMatchersCryptographicValidation;
    protected List<XmlCryptographicValidation> certificateChainCryptographicValidation;

    protected AlgorithmObsolescenceValidation(I18nProvider i18nProvider, T token, Context context, Date validationDate, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlAOV());
        this.token = token;
        this.validationDate = validationDate;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.AOV;
    }

    @Override
    protected void initChain() {
        this.position = this.getPosition();
        this.cryptographicSuite = this.getCryptographicSuite();
        this.buildChain();
    }

    protected abstract ChainItem<XmlAOV> buildChain();

    protected MessageTag getPosition() {
        return ValidationProcessUtils.getCryptoPosition(this.context);
    }

    protected CryptographicSuite getCryptographicSuite() {
        return this.validationPolicy.getSignatureCryptographicConstraint(this.context);
    }

    protected boolean isValid(XmlCryptographicValidation cryptographicValidation) {
        return cryptographicValidation != null && cryptographicValidation.getConclusion() != null && Indication.PASSED == cryptographicValidation.getConclusion().getIndication();
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlAOV)this.result).setValidationTime(this.validationDate);
        ((XmlAOV)this.result).setSignatureCryptographicValidation(this.signatureCryptographicValidation);
        ((XmlAOV)this.result).setSignedAttributesValidation(this.signedAttributesCryptographicValidation);
        ((XmlAOV)this.result).setDigestMatchersValidation(this.digestMatchersCryptographicValidation);
        if (Utils.isCollectionNotEmpty(this.certificateChainCryptographicValidation)) {
            XmlCertificateChainCryptographicValidation xmlCertificateChainCryptographicValidation = new XmlCertificateChainCryptographicValidation();
            xmlCertificateChainCryptographicValidation.getCertificateCryptographicValidation().addAll(this.certificateChainCryptographicValidation);
            ((XmlAOV)this.result).setCertificateChainCryptographicValidation(xmlCertificateChainCryptographicValidation);
        }
    }
}

