/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.aov.TokenAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.SigningCertificateRefDigestAlgorithmCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignatureValueAndSignedAttributesAlgorithmObsolescenceValidation<T extends TokenProxy>
extends TokenAlgorithmObsolescenceValidation<T> {
    public SignatureValueAndSignedAttributesAlgorithmObsolescenceValidation(I18nProvider i18nProvider, T token, Context context, Date validationDate, ValidationPolicy validationPolicy) {
        super(i18nProvider, token, context, validationDate, validationPolicy);
    }

    @Override
    protected ChainItem<XmlAOV> buildChain() {
        ChainItem<XmlAOV> item = super.buildChain();
        item = this.buildSignedAttributesValidationChain(item);
        return item;
    }

    protected ChainItem<XmlAOV> buildSignedAttributesValidationChain(ChainItem<XmlAOV> item) {
        if (!((TokenProxy)this.token).isSigningCertificateReferencePresent()) {
            return item;
        }
        List<CertificateRefWrapper> signingCertificateReferences = ((TokenProxy)this.token).getSigningCertificateReferences();
        CertificateRefWrapper signingCertificateReference = ((TokenProxy)this.token).getSigningCertificateReference();
        XmlCryptographicValidation cryptographicValidation = null;
        HashMap signCertRefsMap = new HashMap();
        signingCertificateReferences.forEach(r -> signCertRefsMap.computeIfAbsent(r.getCertificateId(), s -> new ArrayList()).add(r));
        for (Map.Entry entry : signCertRefsMap.entrySet()) {
            String certificateId = (String)entry.getKey();
            List certificateRefWrappers = (List)entry.getValue();
            SubContext subContext = signingCertificateReference != null && signingCertificateReference.getCertificateId().equals(certificateId) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            SigningCertificateRefDigestAlgorithmCheck<XmlAOV> signCertCheck = this.signingCertificateRefDigestAlgoCheckResult(certificateRefWrappers, certificateId, subContext);
            if (item == null) {
                this.firstItem = signCertCheck;
                item = this.firstItem;
            } else {
                item = item.setNextItem(signCertCheck);
            }
            XmlCC cryptoValidationResult = signCertCheck.getCryptographicValidationResult();
            if (cryptographicValidation != null && (!this.isValid(cryptographicValidation) || this.isValid(cryptoValidationResult))) continue;
            cryptographicValidation = cryptoValidationResult.getCryptographicValidation();
            cryptographicValidation.setTokenId(certificateId);
        }
        this.signedAttributesCryptographicValidation = cryptographicValidation;
        if (this.signedAttributesCryptographicValidation != null) {
            this.signedAttributesCryptographicValidation.setTokenId(((TokenProxy)this.token).getId());
        }
        return item;
    }

    private SigningCertificateRefDigestAlgorithmCheck<XmlAOV> signingCertificateRefDigestAlgoCheckResult(List<CertificateRefWrapper> signCertRefs, String certificateId, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getSigningCertificateDigestAlgorithmConstraint(this.context);
        return new SigningCertificateRefDigestAlgorithmCheck<XmlAOV>(this.i18nProvider, (XmlAOV)this.result, this.validationDate, signCertRefs, certificateId, this.context, subContext, this.validationPolicy, constraint);
    }
}

