/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.AbstractAlgorithmCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.PublicKeySizeAcceptableCheck;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.PublicKeySizeKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.SignatureAlgorithmAtValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.SignatureAlgorithmReliableCheck;
import java.util.Date;

public class SignatureAlgorithmCryptographicChecker
extends AbstractAlgorithmCryptographicChecker {
    private final SignatureAlgorithm signatureAlgorithm;
    private final String keyLengthUsedToSignThisToken;

    public SignatureAlgorithmCryptographicChecker(I18nProvider i18nProvider, SignatureAlgorithm signatureAlgorithm, String keyLengthUsedToSignThisToken, Date validationDate, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, validationDate, position, cryptographicSuite);
        this.signatureAlgorithm = signatureAlgorithm;
        this.keyLengthUsedToSignThisToken = keyLengthUsedToSignThisToken;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCC> item = this.firstItem = this.signatureAlgorithmReliable();
        item = item.setNextItem(this.publicKeySizeKnown());
        item = item.setNextItem(this.publicKeySizeAcceptable());
        item = item.setNextItem(this.signatureAlgorithmOnValidationTime());
    }

    protected ChainItem<XmlCC> signatureAlgorithmReliable() {
        return new SignatureAlgorithmReliableCheck(this.i18nProvider, this.signatureAlgorithm, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> publicKeySizeKnown() {
        return new PublicKeySizeKnownCheck(this.i18nProvider, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> publicKeySizeAcceptable() {
        return new PublicKeySizeAcceptableCheck(this.i18nProvider, this.signatureAlgorithm, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> signatureAlgorithmOnValidationTime() {
        return new SignatureAlgorithmAtValidationTimeCheck(this.i18nProvider, this.signatureAlgorithm, this.keyLengthUsedToSignThisToken, this.validationDate, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    @Override
    protected XmlCryptographicAlgorithm getAlgorithm() {
        if (this.cryptographicAlgorithm == null) {
            this.cryptographicAlgorithm = new XmlCryptographicAlgorithm();
            if (this.signatureAlgorithm != null) {
                this.cryptographicAlgorithm.setName(this.signatureAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getSignatureAlgorithmUri(this.signatureAlgorithm));
                this.cryptographicAlgorithm.setKeyLength(this.keyLengthUsedToSignThisToken);
            } else {
                this.cryptographicAlgorithm.setName("UNIDENTIFIED");
                this.cryptographicAlgorithm.setUri("urn:etsi:019102:algorithm:unidentified");
            }
        }
        return this.cryptographicAlgorithm;
    }

    private String getSignatureAlgorithmUri(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm != null) {
            if (signatureAlgorithm.getUri() != null) {
                return signatureAlgorithm.getUri();
            }
            if (signatureAlgorithm.getOid() != null) {
                return signatureAlgorithm.getURIBasedOnOID();
            }
        }
        return "urn:etsi:019102:algorithm:unidentified";
    }

    @Override
    protected Date getNotAfter() {
        if (CryptographicSuiteUtils.isSignatureAlgorithmReliable(this.cryptographicSuite, this.signatureAlgorithm) && CryptographicSuiteUtils.isSignatureAlgorithmWithKeySizeReliable(this.cryptographicSuite, this.signatureAlgorithm, this.keyLengthUsedToSignThisToken)) {
            return CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.signatureAlgorithm, this.keyLengthUsedToSignThisToken);
        }
        return null;
    }
}

