/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractSignedAndTimestampedFilesCoveredCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final DiagnosticData diagnosticData;
    protected final String timestampFilename;

    protected AbstractSignedAndTimestampedFilesCoveredCheck(I18nProvider i18nProvider, T result, DiagnosticData diagnosticData, String timestampFilename, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.diagnosticData = diagnosticData;
        this.timestampFilename = timestampFilename;
    }

    @Override
    protected boolean process() {
        XmlManifestFile manifestFile = this.diagnosticData.getManifestFileForFilename(this.timestampFilename);
        if (manifestFile != null) {
            return this.checkManifestFilesCovered(manifestFile) && this.isAnyRootLevelDocumentCovered(manifestFile);
        }
        return true;
    }

    private boolean checkManifestFilesCovered(XmlManifestFile timestampManifest) {
        return this.checkManifestFilesCovered(timestampManifest.getEntries());
    }

    protected boolean checkManifestFilesCovered(List<String> entries) {
        return this.checkManifestFilesCoveredRecursively(entries, entries, new HashSet<String>(), true);
    }

    protected boolean checkManifestFilesCoveredRecursively(List<String> coveredEntries, List<String> manifestEntries, Collection<String> checkedEntries, boolean rootProcess) {
        if (Utils.isCollectionNotEmpty(manifestEntries)) {
            for (String manifestEntry : manifestEntries) {
                XmlManifestFile entryManifest;
                if (!rootProcess) {
                    if (!coveredEntries.contains(manifestEntry)) {
                        return false;
                    }
                    if (checkedEntries.contains(manifestEntry)) continue;
                }
                if ((entryManifest = this.diagnosticData.getManifestFileForFilename(manifestEntry)) != null && !this.checkManifestFilesCoveredRecursively(coveredEntries, entryManifest.getEntries(), checkedEntries, false)) {
                    return false;
                }
                checkedEntries.add(manifestEntry);
            }
        }
        return true;
    }

    private boolean isAnyRootLevelDocumentCovered(XmlManifestFile timestampManifest) {
        List<String> rootLevelFiles = this.getRootLevelFiles(this.diagnosticData.getContainerContentFilenames());
        return Utils.containsAny(timestampManifest.getEntries(), rootLevelFiles);
    }

    private List<String> getRootLevelFiles(List<String> fileNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (!this.isRootDirectoryFile(fileName)) continue;
            result.add(fileName);
        }
        return result;
    }

    private boolean isRootDirectoryFile(String fileName) {
        return !fileName.contains("/") && !fileName.contains("\\");
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISFP_ASTFORAMC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISFP_ASTFORAMC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

