/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ArchiveTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CertifiedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ClaimedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CommitmentTypeIndicationsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentHintsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTimestampBasicValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CounterSignatureCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DocumentTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.KeyIdentifierMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.KeyIdentifierPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.MessageDigestOrSignedPropertiesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignerLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningTimeInCertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.StructuralValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ValidationDataRefsOnlyTimeStampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ValidationDataTimeStampCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampMessageImprintWithIdCheck;
import java.util.Date;
import java.util.Map;

public class SignatureAcceptanceValidation
extends AbstractAcceptanceValidation<SignatureWrapper> {
    private final DiagnosticData diagnosticData;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;

    public SignatureAcceptanceValidation(I18nProvider i18nProvider, DiagnosticData diagnosticData, Date currentTime, SignatureWrapper signature, Context context, Map<String, XmlBasicBuildingBlocks> bbbs, XmlAOV aov, ValidationPolicy validationPolicy) {
        super(i18nProvider, signature, currentTime, context, aov, validationPolicy);
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SIGNATURE_ACCEPTANCE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSAV> item = this.firstItem = this.structuralValidation();
        item = item.setNextItem(this.signingCertificateAttributePresent());
        if (((SignatureWrapper)this.token).isSigningCertificateReferencePresent()) {
            item = item.setNextItem(this.unicitySigningCertificateAttribute());
            item = item.setNextItem(this.signingCertificateReferencesValidity());
            item = item.setNextItem(this.allCertificatesInPathReferenced());
        }
        if (SignatureForm.JAdES.equals((Object)((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm())) {
            item = item.setNextItem(this.keyIdentifierPresent());
            if (((SignatureWrapper)this.token).getKeyIdentifierReference() != null) {
                item = item.setNextItem(this.keyIdentifierMatch());
            }
        }
        item = item.setNextItem(this.signingTime());
        if (((SignatureWrapper)this.token).getClaimedSigningTime() != null && ((SignatureWrapper)this.token).getSigningCertificate() != null) {
            item = item.setNextItem(this.signingTimeInCertificateValidityRange());
        }
        item = item.setNextItem(this.contentType());
        item = item.setNextItem(this.contentHints());
        if (!SignatureForm.JAdES.equals((Object)((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm())) {
            item = item.setNextItem(this.messageDigestOrSignedProperties());
        }
        item = item.setNextItem(this.contentIdentifier());
        item = item.setNextItem(this.commitmentTypeIndications());
        item = item.setNextItem(this.signerLocation());
        item = item.setNextItem(this.claimedRoles());
        item = item.setNextItem(this.certifiedRoles());
        item = item.setNextItem(this.contentTimeStamp());
        for (TimestampWrapper contentTimestamp : ((SignatureWrapper)this.token).getContentTimestamps()) {
            XmlBasicBuildingBlocks contentTimestampBBB = this.bbbs.get(contentTimestamp.getId());
            if (contentTimestampBBB != null) {
                item = item.setNextItem(this.contentTimestampBasicValidation(contentTimestamp, contentTimestampBBB.getConclusion()));
            }
            item = item.setNextItem(this.contentTimestampMessageImprint(contentTimestamp));
        }
        item = item.setNextItem(this.counterSignature());
        item = item.setNextItem(this.signatureTimeStamp());
        item = item.setNextItem(this.validationDataTimeStamp());
        item = item.setNextItem(this.validationDataRefsOnlyTimeStamp());
        item = item.setNextItem(this.archiveTimeStamp());
        if (SignatureForm.PAdES.equals((Object)((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm())) {
            item = item.setNextItem(this.documentTimeStamp());
        }
        item = this.cryptographic(item);
    }

    private ChainItem<XmlSAV> structuralValidation() {
        LevelRule constraint = this.validationPolicy.getStructuralValidationConstraint(this.context);
        return new StructuralValidationCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> keyIdentifierPresent() {
        LevelRule constraint = this.validationPolicy.getKeyIdentifierPresent(this.context);
        return new KeyIdentifierPresentCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> keyIdentifierMatch() {
        LevelRule constraint = this.validationPolicy.getKeyIdentifierMatch(this.context);
        return new KeyIdentifierMatchCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signingTime() {
        LevelRule constraint = this.validationPolicy.getSigningTimeConstraint(this.context);
        return new SigningTimeCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signingTimeInCertificateValidityRange() {
        LevelRule constraint = this.validationPolicy.getSigningTimeInCertRangeConstraint(this.context);
        return new SigningTimeInCertificateValidityRangeCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentType() {
        MultiValuesRule constraint = this.validationPolicy.getContentTypeConstraint(this.context);
        return new ContentTypeCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentHints() {
        MultiValuesRule constraint = this.validationPolicy.getContentHintsConstraint(this.context);
        return new ContentHintsCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentIdentifier() {
        MultiValuesRule constraint = this.validationPolicy.getContentIdentifierConstraint(this.context);
        return new ContentIdentifierCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> messageDigestOrSignedProperties() {
        LevelRule constraint = this.validationPolicy.getMessageDigestOrSignedPropertiesConstraint(this.context);
        return new MessageDigestOrSignedPropertiesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> commitmentTypeIndications() {
        MultiValuesRule constraint = this.validationPolicy.getCommitmentTypeIndicationConstraint(this.context);
        return new CommitmentTypeIndicationsCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signerLocation() {
        LevelRule constraint = this.validationPolicy.getSignerLocationConstraint(this.context);
        return new SignerLocationCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentTimeStamp() {
        LevelRule constraint = this.validationPolicy.getContentTimeStampConstraint(this.context);
        return new ContentTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentTimestampBasicValidation(TimestampWrapper timestamp, XmlConclusion xmlConclusion) {
        return new ContentTimestampBasicValidationCheck(this.i18nProvider, (XmlSAV)this.result, timestamp, xmlConclusion, this.getTimestampBasicValidationConstraintLevel());
    }

    private ChainItem<XmlSAV> contentTimestampMessageImprint(TimestampWrapper contentTimestamp) {
        LevelRule constraint = this.validationPolicy.getContentTimeStampMessageImprintConstraint(this.context);
        return new TimestampMessageImprintWithIdCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, contentTimestamp, constraint);
    }

    private ChainItem<XmlSAV> claimedRoles() {
        MultiValuesRule constraint = this.validationPolicy.getClaimedRoleConstraint(this.context);
        return new ClaimedRolesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> certifiedRoles() {
        MultiValuesRule constraint = this.validationPolicy.getCertifiedRolesConstraint(this.context);
        return new CertifiedRolesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> counterSignature() {
        LevelRule constraint = this.validationPolicy.getCounterSignatureConstraint(this.context);
        return new CounterSignatureCheck(this.i18nProvider, (XmlSAV)this.result, this.diagnosticData, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signatureTimeStamp() {
        LevelRule constraint = this.validationPolicy.getSignatureTimeStampConstraint(this.context);
        return new SignatureTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> validationDataTimeStamp() {
        LevelRule constraint = this.validationPolicy.getValidationDataTimeStampConstraint(this.context);
        return new ValidationDataTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> validationDataRefsOnlyTimeStamp() {
        LevelRule constraint = this.validationPolicy.getValidationDataRefsOnlyTimeStampConstraint(this.context);
        return new ValidationDataRefsOnlyTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> archiveTimeStamp() {
        LevelRule constraint = this.validationPolicy.getArchiveTimeStampConstraint(this.context);
        return new ArchiveTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> documentTimeStamp() {
        LevelRule constraint = this.validationPolicy.getDocumentTimeStampConstraint(this.context);
        return new DocumentTimeStampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private LevelRule getTimestampBasicValidationConstraintLevel() {
        LevelRule constraint = this.validationPolicy.getTimestampValidConstraint();
        if (constraint == null || ValidationProcessUtils.isLongTermAvailabilityAndIntegrityMaterialPresent((SignatureWrapper)this.token)) {
            constraint = this.getWarnLevelRule();
        }
        return constraint;
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.TST_BBB.equals((Object)constraint.getBlockType()) || this.validationPolicy.getTimestampValidConstraint() != null && !ValidationProcessUtils.isLongTermAvailabilityAndIntegrityMaterialPresent((SignatureWrapper)this.token)) {
            super.collectMessages(conclusion, constraint);
        }
    }
}

