/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class ContentTimestampBasicValidationCheck
extends ChainItem<XmlSAV> {
    protected final TimestampWrapper timestamp;
    private final XmlConclusion timestampValidationResult;

    public ContentTimestampBasicValidationCheck(I18nProvider i18nProvider, XmlSAV result, TimestampWrapper timestamp, XmlConclusion timestampValidationResult, LevelRule constraint) {
        super(i18nProvider, result, constraint, timestamp.getId());
        this.timestamp = timestamp;
        this.timestampValidationResult = timestampValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_BBB;
    }

    @Override
    protected boolean process() {
        return this.isValidConclusion(this.timestampValidationResult);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ICTVS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ICTVS_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.timestamp.getProductionTime());
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_VALIDATION, new Object[]{ValidationProcessUtils.getTimestampTypeMessageTag(this.timestamp.getType()), this.timestamp.getId(), date});
    }
}

