/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.ArrayList;
import java.util.List;

public class ContentTypeCheck
extends AbstractMultiValuesCheckItem<XmlSAV> {
    private static final String MIME_TYPE_APPLICATION_PREFIX = "application/";
    private final SignatureWrapper signature;

    public ContentTypeCheck(I18nProvider i18nProvider, XmlSAV result, SignatureWrapper signature, MultiValuesRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        return this.processValuesCheck(this.getContentType());
    }

    private List<String> getContentType() {
        ArrayList<String> contentTypes = new ArrayList<String>();
        if (this.signature.getContentType() != null) {
            contentTypes.add(this.signature.getContentType());
        }
        if (SignatureForm.JAdES == this.signature.getSignatureFormat().getSignatureForm() && this.signature.getMimeType() != null) {
            contentTypes.add(this.getRFC7515ContentType(this.signature.getMimeType()));
        }
        return contentTypes;
    }

    private String getRFC7515ContentType(String mimeType) {
        String shortMimeTypeString = DSSUtils.stripFirstLeadingOccurrence(mimeType, MIME_TYPE_APPLICATION_PREFIX);
        if (!shortMimeTypeString.contains("/")) {
            return shortMimeTypeString;
        }
        return mimeType;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPCTP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPCTP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

