/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.RevocationDataAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CertificateValidationBeforeSunsetDateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.crs.CertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityKeyIdentifierPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.BasicConstraintsCACheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.BasicConstraintsMaxPathLengthCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateAlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateForbiddenExtensionsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuerNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcEuRetentionPeriodCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcTransactionLimitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNameConstraintsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotOnHoldCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotRevokedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcRolesOfPSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyQualifiedIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicySupportedByQSCDIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyTreeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcCCLegislationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcComplianceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuLimitValueCurrencyCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuPDSLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcIdentificationMethodCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcQSCDLegislationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcSSCDCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSemanticsIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSupportedCriticalExtensionsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CommonNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CountryCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.EmailCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.ExtendedKeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.GivenNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.KeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.LocalityCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.NoRevAvailCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationUnitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OtherTrustAnchorExistsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudoUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudonymCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationDataRequiredCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerTrustedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SerialNumberCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.StateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SubjectKeyIdentifierPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SurnameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.TitleCheck;
import java.util.Date;

public class SubX509CertificateValidation
extends Chain<XmlSubXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date validationDate;
    private final Date currentTime;
    private final Context context;
    private final SubContext subContext;
    private final XmlAOV aov;
    private final ValidationPolicy validationPolicy;

    public SubX509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date validationDate, Date currentTime, Context context, SubContext subContext, XmlAOV aov, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSubXCV());
        ((XmlSubXCV)this.result).setId(currentCertificate.getId());
        ((XmlSubXCV)this.result).setTrustAnchor(currentCertificate.isTrusted());
        ((XmlSubXCV)this.result).setSelfSigned(currentCertificate.isSelfSigned());
        this.currentCertificate = currentCertificate;
        this.validationDate = validationDate;
        this.currentTime = currentTime;
        this.context = context;
        this.subContext = subContext;
        this.aov = aov;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SUB_XCV;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSubXCV> item = null;
        if (this.currentCertificate.isTrusted()) {
            if (this.currentCertificate.getTrustStartDate() != null || this.currentCertificate.getTrustSunsetDate() != null) {
                this.firstItem = this.validationBeforeSunsetDate(this.currentCertificate, this.subContext, this.currentTime);
                item = this.firstItem;
                if (!ValidationProcessUtils.isTrustAnchor(this.currentCertificate, this.currentTime, this.getFailLevelRule())) {
                    item = item.setNextItem(this.otherTrustAnchorAvailable(this.currentCertificate, this.subContext));
                }
            }
            if (this.isTrustAnchorReached(this.currentCertificate, this.subContext)) {
                return;
            }
        }
        if (item == null) {
            this.firstItem = this.serialNumber(this.currentCertificate, this.subContext);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.serialNumber(this.currentCertificate, this.subContext));
        }
        item = item.setNextItem(this.surname(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.givenName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.commonName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudoUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudonym(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.title(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.email(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.country(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.locality(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.state(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationIdentifier(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationUnit(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.selfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.notSelfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyQualifiedIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicySupportedByQSCDIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCompliance(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuLimitValueCurrency(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateMinQcEuLimitValue(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuRetentionPeriod(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcSSCD(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuPDSLocation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcType(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCCLegislation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToNaturalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSemanticsIdentifier(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcRolesOfPSP(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityId(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcQCSDLegislation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcIdentificationMethod(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSignatureValid(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.ca(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.issuerName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.maxPathLength(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.keyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.extendedKeyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.aiaPresent(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.policyTree(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.nameConstraints(this.currentCertificate, this.subContext));
        if (!this.currentCertificate.isSelfSigned()) {
            item = item.setNextItem(this.authorityKeyIdentifierPresent(this.currentCertificate, this.subContext));
        }
        item = item.setNextItem(this.subjectKeyIdentifierPresent(this.currentCertificate, this.subContext));
        if (this.currentCertificate.isNoRevAvail()) {
            item = item.setNextItem(this.noRevAvail(this.currentCertificate, this.subContext));
        }
        item = item.setNextItem(this.supportedCriticalCertificateExtensions(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.forbiddenCertificateExtensions(this.currentCertificate, this.subContext));
        AbstractTokenProxy latestCertificateRevocation = null;
        RevocationDataRequiredCheck<XmlSubXCV> revocationDataRequired = this.revocationDataRequired(this.currentCertificate, this.subContext);
        boolean isRevocationDataRequired = revocationDataRequired.process();
        if (isRevocationDataRequired) {
            item = item.setNextItem(this.revocationInfoAccessPresent(this.currentCertificate, this.subContext));
            item = item.setNextItem(this.revocationDataPresent(this.currentCertificate, this.subContext));
            if (Utils.isCollectionNotEmpty(this.currentCertificate.getCertificateRevocationData())) {
                CertificateRevocationSelector certificateRevocationSelector = new CertificateRevocationSelector(this.i18nProvider, this.currentCertificate, this.validationDate, this.validationPolicy);
                XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
                ((XmlSubXCV)this.result).setCRS(xmlCRS);
                item = item.setNextItem(this.checkCertificateRevocationSelectorResult(xmlCRS));
                latestCertificateRevocation = certificateRevocationSelector.getLatestAcceptableCertificateRevocation();
                if (latestCertificateRevocation != null && ((CertificateRevocationWrapper)latestCertificateRevocation).isRevoked()) {
                    this.attachRevocationInformation((CertificateRevocationWrapper)latestCertificateRevocation);
                }
                if (this.isValid(xmlCRS)) {
                    item = item.setNextItem(this.certificateNotRevoked((CertificateRevocationWrapper)latestCertificateRevocation, this.subContext, this.validationDate));
                    item = item.setNextItem(this.certificateNotOnHold((CertificateRevocationWrapper)latestCertificateRevocation, this.subContext, this.validationDate));
                    RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCertificateRevocation, this.validationDate, this.context, this.subContext, this.validationPolicy);
                    XmlRFC rfcResult = (XmlRFC)rfc.execute();
                    ((XmlSubXCV)this.result).setRFC(rfcResult);
                    item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(rfcResult));
                }
            }
        } else {
            item = item.setNextItem(revocationDataRequired);
        }
        item = item.setNextItem(this.certificateCryptographic());
        if (latestCertificateRevocation != null) {
            item = item.setNextItem(this.revocationCryptographic((RevocationWrapper)latestCertificateRevocation));
        }
        if (SubContext.SIGNING_CERT == this.subContext) {
            CertificateWrapper revocationIssuerCertificate;
            item = item.setNextItem(this.certificateValidityRange(this.currentCertificate, (CertificateRevocationWrapper)latestCertificateRevocation, isRevocationDataRequired, this.subContext, this.currentTime));
            if (latestCertificateRevocation != null && (revocationIssuerCertificate = latestCertificateRevocation.getSigningCertificate()) != null) {
                item = this.isTrustAnchor(revocationIssuerCertificate, this.context, SubContext.SIGNING_CERT) ? item.setNextItem(this.revocationDataIssuerTrusted(revocationIssuerCertificate)) : item.setNextItem(this.revocationIssuerValidityRange((CertificateRevocationWrapper)latestCertificateRevocation, this.subContext, this.currentTime));
            }
        }
    }

    private void attachRevocationInformation(CertificateRevocationWrapper certificateRevocation) {
        XmlRevocationInformation revocationInfo = new XmlRevocationInformation();
        revocationInfo.setCertificateId(this.currentCertificate.getId());
        revocationInfo.setRevocationId(certificateRevocation.getId());
        revocationInfo.setRevocationDate(certificateRevocation.getRevocationDate());
        revocationInfo.setReason(certificateRevocation.getReason());
        ((XmlSubXCV)this.result).setRevocationInfo(revocationInfo);
    }

    private ChainItem<XmlSubXCV> validationBeforeSunsetDate(CertificateWrapper certificate, SubContext subContext, Date validationTime) {
        LevelRule constraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new CertificateValidationBeforeSunsetDateCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, validationTime, ValidationProcessUtils.getConstraintOrMaxLevel(constraint, Level.WARN));
    }

    private ChainItem<XmlSubXCV> otherTrustAnchorAvailable(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new OtherTrustAnchorExistsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateValidityRange(CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, boolean revocationDataRequired, SubContext subContext, Date validationTime) {
        LevelRule constraint = this.validationPolicy.getCertificateNotExpiredConstraint(this.context, subContext);
        boolean isRevocationIssuerTrusted = usedCertificateRevocation != null && usedCertificateRevocation.getSigningCertificate() != null && this.isTrustAnchor(usedCertificateRevocation.getSigningCertificate(), Context.REVOCATION, SubContext.SIGNING_CERT);
        boolean revocationIssuerCheckEnforced = this.revocationIssuerCheckEnforced(this.context, subContext);
        return new CertificateValidityRangeCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, usedCertificateRevocation, revocationDataRequired, isRevocationIssuerTrusted, revocationIssuerCheckEnforced, validationTime, constraint);
    }

    private boolean revocationIssuerCheckEnforced(Context context, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getRevocationIssuerNotExpiredConstraint(context, subContext);
        return constraint != null && Level.FAIL == constraint.getLevel();
    }

    private ChainItem<XmlSubXCV> revocationDataIssuerTrusted(CertificateWrapper revocationIssuer) {
        LevelRule revocationDataSunsetDate = this.validationPolicy.getCertificateSunsetDateConstraint(Context.REVOCATION, SubContext.SIGNING_CERT);
        return new RevocationIssuerTrustedCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, revocationIssuer, this.currentTime, revocationDataSunsetDate, this.getWarnLevelRule());
    }

    private ChainItem<XmlSubXCV> revocationIssuerValidityRange(CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext, Date validationTime) {
        LevelRule constraint = this.validationPolicy.getRevocationIssuerNotExpiredConstraint(this.context, subContext);
        return new RevocationIssuerValidityRangeCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, usedCertificateRevocation, validationTime, constraint);
    }

    private ChainItem<XmlSubXCV> ca(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateCAConstraint(this.context, subContext);
        return new BasicConstraintsCACheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> issuerName(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateIssuerNameConstraint(this.context, subContext);
        return new CertificateIssuerNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> maxPathLength(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateMaxPathLengthConstraint(this.context, subContext);
        return new BasicConstraintsMaxPathLengthCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> keyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateKeyUsageConstraint(this.context, subContext);
        return new KeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.context, subContext, constraint);
    }

    private ChainItem<XmlSubXCV> extendedKeyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateExtendedKeyUsageConstraint(this.context, subContext);
        return new ExtendedKeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.context, subContext, constraint);
    }

    private ChainItem<XmlSubXCV> aiaPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(this.context, subContext);
        return new AuthorityInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> policyTree(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificatePolicyTreeConstraint(this.context, subContext);
        return new CertificatePolicyTreeCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> nameConstraints(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateNameConstraintsConstraint(this.context, subContext);
        return new CertificateNameConstraintsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private AuthorityKeyIdentifierPresentCheck authorityKeyIdentifierPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateAuthorityKeyIdentifierPresentConstraint(this.context, subContext);
        return new AuthorityKeyIdentifierPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> subjectKeyIdentifierPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSubjectKeyIdentifierPresentConstraint(this.context, subContext);
        return new SubjectKeyIdentifierPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> noRevAvail(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateNoRevAvailConstraint(this.context, subContext);
        return new NoRevAvailCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> supportedCriticalCertificateExtensions(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateSupportedCriticalExtensionsConstraint(this.context, subContext);
        return new CertificateSupportedCriticalExtensionsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> forbiddenCertificateExtensions(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateForbiddenExtensionsConstraint(this.context, subContext);
        return new CertificateForbiddenExtensionsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private RevocationDataRequiredCheck<XmlSubXCV> revocationDataRequired(CertificateWrapper certificate, SubContext subContext) {
        CertificateApplicabilityRule constraint = this.validationPolicy.getRevocationDataSkipConstraint(this.context, subContext);
        LevelRule sunsetDateConstraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new RevocationDataRequiredCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.currentTime, sunsetDateConstraint, constraint);
    }

    private ChainItem<XmlSubXCV> revocationInfoAccessPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(this.context, subContext);
        return new RevocationInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getRevocationDataAvailableConstraint(this.context, subContext);
        return new RevocationDataAvailableCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> checkCertificateRevocationSelectorResult(XmlCRS crsResult) {
        LevelRule constraint = this.validationPolicy.getAcceptableRevocationDataFoundConstraint(this.context, this.subContext);
        return new CertificateRevocationSelectorResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, crsResult, constraint);
    }

    private ChainItem<XmlSubXCV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        return new RevocationFreshnessCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, rfcResult, this.getFailLevelRule());
    }

    private ChainItem<XmlSubXCV> surname(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateSurnameConstraint(this.context, subContext);
        return new SurnameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> givenName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateGivenNameConstraint(this.context, subContext);
        return new GivenNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> commonName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateCommonNameConstraint(this.context, subContext);
        return new CommonNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudonym(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificatePseudonymConstraint(this.context, subContext);
        return new PseudonymCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> title(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateTitleConstraint(this.context, subContext);
        return new TitleCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> email(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateEmailConstraint(this.context, subContext);
        return new EmailCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> country(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateCountryConstraint(this.context, subContext);
        return new CountryCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> locality(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateLocalityConstraint(this.context, subContext);
        return new LocalityCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> state(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateStateConstraint(this.context, subContext);
        return new StateCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationIdentifier(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateOrganizationIdentifierConstraint(this.context, subContext);
        return new OrganizationIdentifierCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateOrganizationNameConstraint(this.context, subContext);
        return new OrganizationNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationUnit(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateOrganizationUnitConstraint(this.context, subContext);
        return new OrganizationUnitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> serialNumber(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSerialNumberConstraint(this.context, subContext);
        return new SerialNumberCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudoUsage(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificatePseudoUsageConstraint(this.context, subContext);
        return new PseudoUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateNotRevoked(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext, Date validationTime) {
        LevelRule constraint = this.validationPolicy.getCertificateNotRevokedConstraint(this.context, subContext);
        return new CertificateNotRevokedCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, validationTime, constraint, subContext);
    }

    private ChainItem<XmlSubXCV> certificateNotOnHold(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext, Date validationTime) {
        LevelRule constraint = this.validationPolicy.getCertificateNotOnHoldConstraint(this.context, subContext);
        return new CertificateNotOnHoldCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, validationTime, constraint);
    }

    private ChainItem<XmlSubXCV> notSelfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateNotSelfSignedConstraint(this.context, subContext);
        return new CertificateNotSelfSignedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> selfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSelfSignedConstraint(this.context, subContext);
        return new CertificateSelfSignedCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificatePolicyIdsConstraint(this.context, subContext);
        return new CertificatePolicyIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyQualifiedIds(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificatePolicyQualificationIdsConstraint(this.context, subContext);
        return new CertificatePolicyQualifiedIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicySupportedByQSCDIds(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificatePolicySupportedByQSCDIdsConstraint(this.context, subContext);
        return new CertificatePolicySupportedByQSCDIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCompliance(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateQCComplianceConstraint(this.context, subContext);
        return new CertificateQcComplianceCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateMinQcEuLimitValue(CertificateWrapper certificate, SubContext subContext) {
        NumericValueRule constraint = this.validationPolicy.getCertificateMinQcEuLimitValueConstraint(this.context, subContext);
        return new CertificateMinQcTransactionLimitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuLimitValueCurrency(CertificateWrapper certificate, SubContext subContext) {
        ValueRule constraint = this.validationPolicy.getCertificateQcEuLimitValueCurrencyConstraint(this.context, subContext);
        return new CertificateQcEuLimitValueCurrencyCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuRetentionPeriod(CertificateWrapper certificate, SubContext subContext) {
        NumericValueRule constraint = this.validationPolicy.getCertificateMinQcEuRetentionPeriodConstraint(this.context, subContext);
        return new CertificateMinQcEuRetentionPeriodCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcSSCD(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateQcSSCDConstraint(this.context, subContext);
        return new CertificateQcSSCDCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuPDSLocation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateQcEuPDSLocationConstraint(this.context, subContext);
        return new CertificateQcEuPDSLocationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcType(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateQcTypeConstraint(this.context, subContext);
        return new CertificateQcTypeCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCCLegislation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateQcCCLegislationConstraint(this.context, subContext);
        return new CertificateQcCCLegislationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToNaturalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToLegalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSemanticsIdentifier(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateSemanticsIdentifierConstraint(this.context, subContext);
        return new CertificateSemanticsIdentifierCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcRolesOfPSP(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificatePS2DQcTypeRolesOfPSPConstraint(this.context, subContext);
        return new CertificatePS2DQcRolesOfPSPCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityNameConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityId(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityIdConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityIdCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcQCSDLegislation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateQcQSCDLegislationConstraint(this.context, subContext);
        return new CertificateQcQSCDLegislationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcIdentificationMethod(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesRule constraint = this.validationPolicy.getCertificateQcIdentificationMethodConstraint(this.context, subContext);
        return new CertificateQcIdentificationMethodCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateCryptographic() {
        MessageTag certificatePosition = ValidationProcessUtils.getSubContextPosition(Context.CERTIFICATE, this.subContext);
        return new CertificateAlgorithmObsolescenceValidationCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, this.aov, this.currentTime, certificatePosition, this.currentCertificate.getId());
    }

    private ChainItem<XmlSubXCV> revocationCryptographic(RevocationWrapper revocationData) {
        RevocationDataAlgorithmObsolescenceValidation aov = new RevocationDataAlgorithmObsolescenceValidation(this.i18nProvider, revocationData, this.currentTime, this.validationPolicy);
        MessageTag position = ValidationProcessUtils.getCryptoPosition(Context.REVOCATION);
        return new AlgorithmObsolescenceValidationCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, (XmlAOV)aov.execute(), this.currentTime, position, revocationData.getId());
    }

    private boolean isTrustAnchorReached(CertificateWrapper certificateWrapper, SubContext subContext) {
        return this.isTrustAnchor(certificateWrapper, this.context, subContext) || !certificateWrapper.isTrustedChain();
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, Context context, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSunsetDateConstraint(context, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, this.currentTime, constraint);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        XmlRFC xmlRFC;
        super.collectAdditionalMessages(conclusion);
        XmlCRS xmlCRS = ((XmlSubXCV)this.result).getCRS();
        if (xmlCRS != null && this.isValid(xmlCRS)) {
            this.collectAllMessages(conclusion, xmlCRS.getConclusion());
        }
        if ((xmlRFC = ((XmlSubXCV)this.result).getRFC()) != null && this.isValid(xmlRFC)) {
            this.collectAllMessages(conclusion, xmlRFC.getConclusion());
        }
        if (this.aov != null && this.isValid(this.aov)) {
            this.collectAllMessages(conclusion, this.aov.getConclusion());
        }
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (XmlBlockType.AOV != constraint.getBlockType()) {
            super.collectMessages(conclusion, constraint);
        }
    }
}

