/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import java.util.List;

class TypeByTL
implements TypeStrategy {
    private final TrustServiceWrapper trustService;
    private final CertificateQualifiedStatus qualified;
    private final TypeStrategy typeInCert;

    public TypeByTL(TrustServiceWrapper trustService, CertificateQualifiedStatus qualified, TypeStrategy typeInCert) {
        this.trustService = trustService;
        this.qualified = qualified;
        this.typeInCert = typeInCert;
    }

    @Override
    public CertificateType getType() {
        if (CertificateQualifiedStatus.isQC(this.qualified)) {
            if (this.trustService == null) {
                return CertificateType.UNKNOWN;
            }
            if (EIDASUtils.isPreEIDAS(this.trustService.getStartDate())) {
                return CertificateType.ESIGN;
            }
            List<String> usageQualifiers = ServiceQualification.getUsageQualifiers(this.trustService.getCapturedQualifierUris());
            if (Utils.collectionSize(usageQualifiers) > 1) {
                return CertificateType.UNKNOWN;
            }
            if (Utils.isCollectionNotEmpty(usageQualifiers)) {
                if (ServiceQualification.isQcForEsig(usageQualifiers)) {
                    return CertificateType.ESIGN;
                }
                if (ServiceQualification.isQcForEseal(usageQualifiers)) {
                    return CertificateType.ESEAL;
                }
                if (ServiceQualification.isQcForWSA(usageQualifiers)) {
                    return CertificateType.WSA;
                }
            }
        }
        return this.typeInCert.getType();
    }
}

