/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.QWAC2ValidationProcessBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWAC2ValidationResultCheck;
import java.util.Date;
import java.util.Map;

public class QWACForTLSBindingCertificateValidationBlock
extends Chain<XmlQWACProcess> {
    private final SignatureWrapper bindingSignature;
    private final CertificateWrapper certificate;
    private final Date validationTime;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final XmlCertificateQualificationProcess certificateQualification;
    private final String websiteUrl;

    public QWACForTLSBindingCertificateValidationBlock(I18nProvider i18nProvider, Date validationTime, SignatureWrapper bindingSignature, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, XmlCertificateQualificationProcess certificateQualification, String websiteUrl) {
        super(i18nProvider, new XmlQWACProcess());
        ((XmlQWACProcess)this.result).setId(certificate.getId());
        this.bindingSignature = bindingSignature;
        this.certificate = certificate;
        this.validationTime = validationTime;
        this.bbbs = bbbs;
        this.certificateQualification = certificateQualification;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.QWAC_VALIDATION;
    }

    @Override
    protected void initChain() {
        XmlConclusion xmlConclusion = this.getSigningCertificateValidationProcessConclusion();
        QWAC2ValidationProcessBlock qwac2Process = new QWAC2ValidationProcessBlock(this.i18nProvider, this.validationTime, this.certificate, xmlConclusion, this.certificateQualification, this.websiteUrl);
        XmlValidationQWACProcess qwac2ValidationResult = (XmlValidationQWACProcess)qwac2Process.execute();
        ((XmlQWACProcess)this.result).getValidationQWACProcess().add(qwac2ValidationResult);
        ChainItem<XmlQWACProcess> item = this.firstItem = this.qwacValidation(qwac2ValidationResult);
        if (this.isValid(qwac2ValidationResult)) {
            ((XmlQWACProcess)this.result).setQWACType(qwac2Process.getQWACProfile());
        } else {
            ((XmlQWACProcess)this.result).setQWACType(QWACProfile.NOT_QWAC);
        }
    }

    private ChainItem<XmlQWACProcess> qwacValidation(XmlValidationQWACProcess ... qwacValidationProcesses) {
        return new QWAC2ValidationResultCheck(this.i18nProvider, (XmlQWACProcess)this.result, qwacValidationProcesses, this.getFailLevelRule());
    }

    private XmlConclusion getSigningCertificateValidationProcessConclusion() {
        XmlBasicBuildingBlocks signatureBBB = this.bbbs.get(this.bindingSignature.getId());
        if (signatureBBB == null) {
            throw new IllegalStateException(String.format("The signature basic validation process shall be performed! No BasicBuildingBlock found for a signature with Id '%s'", this.certificate.getId()));
        }
        XmlXCV xcv = signatureBBB.getXCV();
        for (XmlSubXCV subXCV : xcv.getSubXCV()) {
            if (!this.certificate.getId().equals(subXCV.getId())) continue;
            return subXCV.getConclusion();
        }
        return xcv.getConclusion();
    }
}

