/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.CertificatePolicy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Arrays;
import java.util.List;

public class QWACCertificatePolicyCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final CertificateWrapper certificate;
    private final QWACProfile qwacProfile;

    public QWACCertificatePolicyCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, CertificateWrapper certificate, QWACProfile qwacProfile, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.qwacProfile = qwacProfile;
    }

    @Override
    protected boolean process() {
        switch (this.qwacProfile) {
            case QWAC_1: {
                return this.certificatePolicyMatch(CertificatePolicy.QCP_WEB, CertificatePolicy.QNCP_WEB);
            }
            case QWAC_2: {
                return this.certificatePolicyMatch(CertificatePolicy.QNCP_WEB_GEN);
            }
        }
        throw new UnsupportedOperationException(String.format("The QWAC profile '%s' is not supported!", new Object[]{this.qwacProfile}));
    }

    private boolean certificatePolicyMatch(CertificatePolicy ... policies) {
        List<String> certificatePoliciesOids = this.certificate.getCertificatePoliciesOids();
        return Utils.isCollectionNotEmpty(certificatePoliciesOids) && certificatePoliciesOids.stream().anyMatch(k -> Arrays.stream(policies).anyMatch(m -> m.getOid().equals(k)));
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.QWAC_CERT_POLICY, new Object[]{ValidationProcessUtils.getQWACValidationMessageTag(this.qwacProfile)});
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.QWAC_CERT_POLICY_ANS, new Object[]{ValidationProcessUtils.getQWACValidationMessageTag(this.qwacProfile)});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

