/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralName;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class QWACDomainNameCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final CertificateWrapper certificate;
    private final String websiteUrl;

    public QWACDomainNameCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, CertificateWrapper certificate, String websiteUrl, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected boolean process() {
        String host = DSSUtils.getHost(this.websiteUrl);
        for (XmlGeneralName generalName : this.certificate.getSubjectAlternativeNames()) {
            switch (generalName.getType()) {
                case DNS_NAME: {
                    if (!this.matchesDNSName(host, generalName.getValue())) break;
                    return true;
                }
                case IP_ADDRESS: {
                    if (!this.matchesIPAddress(host, generalName.getValue())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesDNSName(String hostname, String subAltName) {
        if ((subAltName = subAltName.toLowerCase()).equals(hostname = hostname.toLowerCase())) {
            return true;
        }
        if (subAltName.startsWith("*.") && hostname.contains(".")) {
            String suffix = subAltName.substring(2);
            return hostname.endsWith(suffix) && this.countParts(hostname) == this.countParts(suffix) + 1;
        }
        return false;
    }

    private int countParts(String domain) {
        return domain.split("\\.").length;
    }

    private boolean matchesIPAddress(String hostname, String subAltName) {
        return hostname.equals(subAltName);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QWAC_DOMAIN_NAME;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QWAC_DOMAIN_NAME_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

