/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.timestamp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualificationAtTime;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableListOfTrustedListsCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListPresenceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.TrustedListReachedForCertificateChainCheck;
import eu.europa.esig.dss.validation.process.qualification.timestamp.TimestampQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TimestampQualificationBlock
extends Chain<XmlValidationTimestampQualification> {
    private final TimestampWrapper timestamp;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final POEExtraction poe;
    private final List<XmlTLAnalysis> relatedTLAnalyses = new ArrayList<XmlTLAnalysis>();
    private TimestampQualification tstQualification = TimestampQualification.NA;

    public TimestampQualificationBlock(I18nProvider i18nProvider, TimestampWrapper timestamp, List<XmlTLAnalysis> tlAnalysis, POEExtraction poe) {
        super(i18nProvider, new XmlValidationTimestampQualification());
        this.timestamp = timestamp;
        this.tlAnalysis = tlAnalysis;
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.TST_QUALIFICATION;
    }

    @Override
    protected void initChain() {
        CertificateWrapper signingCertificate = this.timestamp.getSigningCertificate();
        ChainItem<XmlValidationTimestampQualification> item = this.firstItem = this.isTrustedListReachedForCertificateChain(signingCertificate);
        if (signingCertificate != null && signingCertificate.isTrustedListReached()) {
            List<TrustServiceWrapper> originalTSPs = signingCertificate.getTrustServices();
            Set listOfTrustedListUrls = originalTSPs.stream().filter(t -> t.getListOfTrustedLists() != null).map(t -> t.getListOfTrustedLists().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableLOTLUrls = new HashSet<String>();
            for (String lotlURL : listOfTrustedListUrls) {
                XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(lotlURL);
                if (lotlAnalysis == null) continue;
                this.relatedTLAnalyses.add(lotlAnalysis);
                AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification> acceptableLOTL = this.isAcceptableLOTL(lotlAnalysis);
                item = item.setNextItem(acceptableLOTL);
                if (!acceptableLOTL.process()) continue;
                acceptableLOTLUrls.add(lotlURL);
            }
            Set trustedListUrls = originalTSPs.stream().filter(t -> t.getTrustedList() != null && (t.getListOfTrustedLists() == null || acceptableLOTLUrls.contains(t.getListOfTrustedLists().getUrl()))).map(t -> t.getTrustedList().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableTLUrls = new HashSet<String>();
            if (Utils.isCollectionNotEmpty(trustedListUrls)) {
                for (String tlURL : trustedListUrls) {
                    XmlTLAnalysis currentTL = this.getTlAnalysis(tlURL);
                    if (currentTL == null) continue;
                    this.relatedTLAnalyses.add(currentTL);
                    AcceptableTrustedListCheck<XmlValidationTimestampQualification> acceptableTL = this.isAcceptableTL(currentTL);
                    item = item.setNextItem(acceptableTL);
                    if (!acceptableTL.process()) continue;
                    acceptableTLUrls.add(tlURL);
                }
            }
            item = item.setNextItem(this.isAcceptableTLPresent(acceptableTLUrls));
            if (Utils.isCollectionNotEmpty(acceptableTLUrls)) {
                TrustServiceFilter filter = TrustServicesFilterFactory.createFilterByUrls(acceptableTLUrls);
                List<TrustServiceWrapper> acceptableServices = filter.filter(originalTSPs);
                TimestampQualificationAtTimeBlock tstQualificationAtGenerationTimeBlock = new TimestampQualificationAtTimeBlock(this.i18nProvider, ValidationTime.TIMESTAMP_GENERATION_TIME, this.timestamp, acceptableServices);
                XmlValidationTimestampQualificationAtTime conclusionAtGenerationTime = (XmlValidationTimestampQualificationAtTime)tstQualificationAtGenerationTimeBlock.execute();
                ((XmlValidationTimestampQualification)this.result).getValidationTimestampQualificationAtTime().add(conclusionAtGenerationTime);
                Date timestampPOE = this.poe.getLowestPOETime(this.timestamp.getId());
                TimestampQualificationAtTimeBlock tstQualificationAtPOETimeBlock = new TimestampQualificationAtTimeBlock(this.i18nProvider, ValidationTime.TIMESTAMP_POE_TIME, timestampPOE, this.timestamp, acceptableServices);
                XmlValidationTimestampQualificationAtTime conclusionAtPOETime = (XmlValidationTimestampQualificationAtTime)tstQualificationAtPOETimeBlock.execute();
                ((XmlValidationTimestampQualification)this.result).getValidationTimestampQualificationAtTime().add(conclusionAtPOETime);
                this.determineFinalQualification(conclusionAtGenerationTime.getTimestampQualification(), conclusionAtPOETime.getTimestampQualification());
            }
        }
    }

    private XmlTLAnalysis getTlAnalysis(String url) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual(url, xmlTLAnalysis.getURL())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    private void determineFinalQualification(TimestampQualification qualAtGenerationTime, TimestampQualification qualAtPOETime) {
        this.tstQualification = TimestampQualification.QTSA == qualAtGenerationTime && TimestampQualification.QTSA == qualAtPOETime ? TimestampQualification.QTSA : TimestampQualification.TSA;
    }

    @Override
    protected void addAdditionalInfo() {
        this.setIndication();
        this.setTimestampQualification();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlValidationTimestampQualification)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private void setTimestampQualification() {
        ((XmlValidationTimestampQualification)this.result).setTimestampQualification(this.tstQualification);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlValidationTimestampQualificationAtTime tstQualAtTime : ((XmlValidationTimestampQualification)this.result).getValidationTimestampQualificationAtTime()) {
            this.collectAllMessages(conclusion, tstQualAtTime.getConclusion());
        }
        for (XmlTLAnalysis relatedTLAnalysis : this.relatedTLAnalyses) {
            this.collectAllMessages(conclusion, relatedTLAnalysis.getConclusion());
        }
    }

    private ChainItem<XmlValidationTimestampQualification> isTrustedListReachedForCertificateChain(CertificateWrapper signingCertificate) {
        return new TrustedListReachedForCertificateChainCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, signingCertificate, this.getFailLevelRule());
    }

    private AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification> isAcceptableLOTL(XmlTLAnalysis xmlLOTLAnalysis) {
        return new AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, xmlLOTLAnalysis, this.getWarnLevelRule());
    }

    private AcceptableTrustedListCheck<XmlValidationTimestampQualification> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, xmlTLAnalysis, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationTimestampQualification> isAcceptableTLPresent(Set<String> acceptableUrls) {
        return new AcceptableTrustedListPresenceCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, acceptableUrls, this.getFailLevelRule());
    }
}

